/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.session;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.util.JsonSerialization;

public class PersistentUserSessionAdapter
implements OfflineUserSessionModel {
    private final PersistentUserSessionModel model;
    private UserModel user;
    private String userId;
    private RealmModel realm;
    private KeycloakSession session;
    private final Map<String, AuthenticatedClientSessionModel> authenticatedClientSessions;
    private PersistentUserSessionData data;

    public PersistentUserSessionAdapter(UserSessionModel other) {
        this.data = new PersistentUserSessionData();
        this.data.setAuthMethod(other.getAuthMethod());
        this.data.setBrokerSessionId(other.getBrokerSessionId());
        this.data.setBrokerUserId(other.getBrokerUserId());
        this.data.setIpAddress(other.getIpAddress());
        this.data.setNotes(other.getNotes());
        this.data.setRememberMe(other.isRememberMe());
        if (other.getState() != null) {
            this.data.setState(other.getState().toString());
        }
        this.model = new PersistentUserSessionModel(){
            private String userSessionId;
            private int started;
            private int lastSessionRefresh;
            private boolean offline;
            private String data;

            @Override
            public String getUserSessionId() {
                return this.userSessionId;
            }

            @Override
            public void setUserSessionId(String userSessionId) {
                this.userSessionId = userSessionId;
            }

            @Override
            public int getStarted() {
                return this.started;
            }

            @Override
            public void setStarted(int started) {
                this.started = started;
            }

            @Override
            public int getLastSessionRefresh() {
                return this.lastSessionRefresh;
            }

            @Override
            public void setLastSessionRefresh(int lastSessionRefresh) {
                this.lastSessionRefresh = lastSessionRefresh;
            }

            @Override
            public boolean isOffline() {
                return this.offline;
            }

            @Override
            public void setOffline(boolean offline) {
                this.offline = offline;
            }

            @Override
            public String getData() {
                return this.data;
            }

            @Override
            public void setData(String data) {
                this.data = data;
            }

            @Override
            public void setRealmId(String realmId) {
            }

            @Override
            public void setUserId(String userId) {
            }

            @Override
            public void setBrokerSessionId(String brokerSessionId) {
            }
        };
        this.model.setStarted(other.getStarted());
        this.model.setUserSessionId(other.getId());
        this.model.setLastSessionRefresh(other.getLastSessionRefresh());
        this.user = other.getUser();
        this.userId = this.user.getId();
        this.realm = other.getRealm();
        this.authenticatedClientSessions = other.getAuthenticatedClientSessions();
    }

    public PersistentUserSessionAdapter(KeycloakSession session, PersistentUserSessionModel model, RealmModel realm, String userId, Map<String, AuthenticatedClientSessionModel> clientSessions) {
        this.session = session;
        this.model = model;
        this.realm = realm;
        this.userId = userId;
        this.authenticatedClientSessions = clientSessions;
    }

    private PersistentUserSessionData getData() {
        if (this.data == null) {
            try {
                this.data = (PersistentUserSessionData)JsonSerialization.readValue((String)this.model.getData(), PersistentUserSessionData.class);
            }
            catch (IOException ioe) {
                throw new ModelException("Error restoring session", (Throwable)ioe);
            }
        }
        return this.data;
    }

    public PersistentUserSessionModel getUpdatedModel() {
        try {
            String updatedData = JsonSerialization.writeValueAsString((Object)this.getData());
            this.model.setData(updatedData);
        }
        catch (IOException ioe) {
            throw new ModelException("Error persisting session", (Throwable)ioe);
        }
        return this.model;
    }

    public String getId() {
        return this.model.getUserSessionId();
    }

    public String getBrokerSessionId() {
        return this.getData().getBrokerSessionId();
    }

    public String getBrokerUserId() {
        return this.getData().getBrokerUserId();
    }

    public UserModel getUser() {
        if (this.user == null) {
            this.user = LightweightUserAdapter.isLightweightUser((String)this.userId) ? LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)this.realm, (String)this.getData().getNotes().get("keycloak.userModel")) : this.session.users().getUserById(this.realm, this.userId);
        }
        return this.user;
    }

    public String getUserId() {
        return this.userId;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getLoginUsername() {
        if (this.isOffline() || !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            return this.getUser().getUsername();
        }
        return this.getData().getLoginUsername();
    }

    public String getIpAddress() {
        return this.getData().getIpAddress();
    }

    public String getAuthMethod() {
        return this.getData().getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.getData().isRememberMe();
    }

    public int getStarted() {
        return this.model.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.model.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        if (seconds <= this.getLastSessionRefresh()) {
            return;
        }
        this.model.setLastSessionRefresh(seconds);
    }

    public boolean isOffline() {
        return this.model.isOffline();
    }

    public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
        return this.authenticatedClientSessions;
    }

    public void removeAuthenticatedClientSessions(Collection<String> removedClientUUIDS) {
        if (removedClientUUIDS == null || !removedClientUUIDS.iterator().hasNext()) {
            return;
        }
        removedClientUUIDS.forEach(this.authenticatedClientSessions::remove);
    }

    public String getNote(String name) {
        return this.getData().getNotes() == null ? null : this.getData().getNotes().get(name);
    }

    public void setNote(String name, String value) {
        PersistentUserSessionData data = this.getData();
        if (data.getNotes() == null) {
            data.setNotes(new HashMap<String, String>());
        }
        data.getNotes().put(name, value);
    }

    public void removeNote(String name) {
        if (this.getData().getNotes() != null) {
            this.getData().getNotes().remove(name);
        }
    }

    public Map<String, String> getNotes() {
        return this.getData().getNotes();
    }

    public UserSessionModel.State getState() {
        String state = this.getData().getState();
        if (state == null) {
            return null;
        }
        if (state.equals("LOGGING_IN")) {
            return UserSessionModel.State.LOGGED_IN;
        }
        return UserSessionModel.State.valueOf((String)state);
    }

    public void setState(UserSessionModel.State state) {
        String stateStr = state == null ? null : state.toString();
        this.getData().setState(stateStr);
    }

    public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        throw new IllegalStateException("Not supported");
    }

    public void setLoginUsername(String loginUsername) {
        this.getData().setLoginUsername(loginUsername);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public void setRealm(RealmModel realm) {
        this.realm = realm;
        this.model.setRealmId(realm.getId());
    }

    public void setUser(UserModel user) {
        this.user = user;
        this.model.setUserId(user.getId());
    }

    public void setIpAddress(String ipAddress) {
        this.getData().setIpAddress(ipAddress);
    }

    public void setAuthMethod(String authMethod) {
        this.getData().setAuthMethod(authMethod);
    }

    public void setRememberMe(boolean rememberMe) {
        this.getData().setRememberMe(rememberMe);
    }

    public void setStarted(int started) {
        this.getData().setStarted(started);
    }

    public void setBrokerSessionId(String brokerSessionId) {
        this.getData().setBrokerSessionId(brokerSessionId);
        this.model.setBrokerSessionId(brokerSessionId);
    }

    public void setBrokerUserId(String brokerUserId) {
        this.getData().setBrokerUserId(brokerUserId);
    }

    protected static class PersistentUserSessionData {
        @JsonProperty(value="brokerSessionId")
        private String brokerSessionId;
        @JsonProperty(value="brokerUserId")
        private String brokerUserId;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="authMethod")
        private String authMethod;
        @JsonProperty(value="rememberMe")
        private boolean rememberMe;
        @JsonProperty(value="started")
        private int started;
        @JsonProperty(value="notes")
        private Map<String, String> notes;
        @JsonProperty(value="state")
        private String state;
        @JsonProperty(value="loginUsername")
        private String loginUsername;

        protected PersistentUserSessionData() {
        }

        public String getBrokerSessionId() {
            return this.brokerSessionId;
        }

        public void setBrokerSessionId(String brokerSessionId) {
            this.brokerSessionId = brokerSessionId;
        }

        public String getBrokerUserId() {
            return this.brokerUserId;
        }

        public void setBrokerUserId(String brokerUserId) {
            this.brokerUserId = brokerUserId;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public void setAuthMethod(String authMethod) {
            this.authMethod = authMethod;
        }

        public boolean isRememberMe() {
            return this.rememberMe;
        }

        public void setRememberMe(boolean rememberMe) {
            this.rememberMe = rememberMe;
        }

        @Deprecated
        public int getStarted() {
            return this.started;
        }

        @Deprecated
        public void setStarted(int started) {
            this.started = started;
        }

        public Map<String, String> getNotes() {
            return this.notes;
        }

        public void setNotes(Map<String, String> notes) {
            this.notes = notes;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setLoginUsername(String loginUsername) {
            this.loginUsername = loginUsername;
        }

        public String getLoginUsername() {
            return this.loginUsername;
        }
    }
}

