/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.repository.internal.MavenMetadata;
import org.eclipse.aether.metadata.Metadata;

final class PluginsMetadata
extends MavenMetadata {
    private final PluginInfo pluginInfo;

    PluginsMetadata(PluginInfo pluginInfo, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), null, timestamp);
        this.pluginInfo = pluginInfo;
    }

    PluginsMetadata(PluginInfo pluginInfo, File file, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), file, timestamp);
        this.pluginInfo = pluginInfo;
    }

    private static Metadata createRepositoryMetadata(PluginInfo pluginInfo) {
        Metadata result = new Metadata();
        Plugin plugin = new Plugin();
        plugin.setPrefix(pluginInfo.goalPrefix);
        plugin.setArtifactId(pluginInfo.artifactId);
        plugin.setName(pluginInfo.name);
        result.getPlugins().add(plugin);
        return result;
    }

    @Override
    protected void merge(Metadata recessive) {
        List recessivePlugins = recessive.getPlugins();
        List plugins = this.metadata.getPlugins();
        if (!plugins.isEmpty()) {
            LinkedHashMap mergedPlugins = new LinkedHashMap();
            recessivePlugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            plugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            this.metadata.setPlugins(new ArrayList(mergedPlugins.values()));
        }
    }

    public MavenMetadata setFile(File file) {
        return new PluginsMetadata(this.pluginInfo, file, this.timestamp);
    }

    public String getGroupId() {
        return this.pluginInfo.groupId;
    }

    public String getArtifactId() {
        return "";
    }

    public String getVersion() {
        return "";
    }

    public Metadata.Nature getNature() {
        return Metadata.Nature.RELEASE_OR_SNAPSHOT;
    }

    static final class PluginInfo {
        final String groupId;
        private final String artifactId;
        private final String goalPrefix;
        private final String name;

        PluginInfo(String groupId, String artifactId, String goalPrefix, String name) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.goalPrefix = goalPrefix;
            this.name = name;
        }
    }
}

