/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.AmqpErrorCode;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import com.microsoft.azure.eventhubs.impl.WebSocketConnectionHandler;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyHandlerImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.apache.qpid.proton.amqp.transport.ConnectionError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProxyConnectionHandler
extends WebSocketConnectionHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(WebSocketProxyConnectionHandler.class);
    private final String proxySelectorModifiedError = "ProxySelector has been modified.";

    public static Boolean shouldUseProxy(String hostName) {
        URI uri = WebSocketProxyConnectionHandler.createURIFromHostNamePort(hostName, 443);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            return false;
        }
        List<Proxy> proxies = proxySelector.select(uri);
        return WebSocketProxyConnectionHandler.isProxyAddressLegal(proxies);
    }

    public WebSocketProxyConnectionHandler(AmqpConnection amqpConnection) {
        super(amqpConnection);
    }

    @Override
    protected void addTransportLayers(Event event, TransportInternal transport) {
        super.addTransportLayers(event, transport);
        ProxyImpl proxy = new ProxyImpl();
        String hostName = event.getConnection().getHostname();
        ProxyHandlerImpl proxyHandler = new ProxyHandlerImpl();
        proxy.configure(hostName, null, (ProxyHandler)proxyHandler, (Transport)transport);
        transport.addTransportLayer((TransportLayer)proxy);
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info("addProxyHandshake: hostname[" + hostName + "]");
        }
    }

    @Override
    protected void notifyTransportErrors(Event event) {
        int port;
        Transport transport = event.getTransport();
        Connection connection = event.getConnection();
        if (connection == null || transport == null) {
            return;
        }
        ErrorCondition errorCondition = transport.getCondition();
        String hostName = event.getReactor().getConnectionAddress(connection);
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (errorCondition == null || !errorCondition.getCondition().equals(ConnectionError.FRAMING_ERROR) && !errorCondition.getCondition().equals(AmqpErrorCode.PROTON_IO_ERROR) || proxySelector == null || StringUtil.isNullOrEmpty(hostName)) {
            return;
        }
        String[] hostNameParts = hostName.split(":");
        if (hostNameParts.length != 2) {
            return;
        }
        try {
            port = Integer.parseInt(hostNameParts[1]);
        }
        catch (NumberFormatException ignore) {
            return;
        }
        IOException ioException = WebSocketProxyConnectionHandler.reconstructIOException(errorCondition);
        proxySelector.connectFailed(WebSocketProxyConnectionHandler.createURIFromHostNamePort(this.getAmqpConnection().getHostName(), this.getProtocolPort()), new InetSocketAddress(hostNameParts[0], port), ioException);
    }

    @Override
    public String getRemoteHostName() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getHostString();
    }

    @Override
    public int getRemotePort() {
        InetSocketAddress socketAddress = this.getProxyAddress();
        return socketAddress.getPort();
    }

    private InetSocketAddress getProxyAddress() {
        URI serviceUri = WebSocketProxyConnectionHandler.createURIFromHostNamePort(this.getAmqpConnection().getHostName(), this.getProtocolPort());
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector == null) {
            throw new IllegalStateException("ProxySelector has been modified.");
        }
        List<Proxy> proxies = proxySelector.select(serviceUri);
        if (!WebSocketProxyConnectionHandler.isProxyAddressLegal(proxies)) {
            throw new IllegalStateException("ProxySelector has been modified.");
        }
        Proxy proxy = proxies.get(0);
        return (InetSocketAddress)proxy.address();
    }

    private static URI createURIFromHostNamePort(String hostName, int port) {
        return URI.create(String.format("https://%s:%s", hostName, port));
    }

    private static boolean isProxyAddressLegal(List<Proxy> proxies) {
        return proxies != null && !proxies.isEmpty() && proxies.get(0).type() == Proxy.Type.HTTP && proxies.get(0).address() != null && proxies.get(0).address() instanceof InetSocketAddress;
    }

    private static IOException reconstructIOException(ErrorCondition errorCondition) {
        return new IOException(errorCondition.getDescription());
    }
}

