/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.AutoPositioningStream;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UpdatableBlobStream;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class EmbedBlob
extends ConnectionChild
implements Blob,
EngineLOB {
    private boolean materialized;
    private PositionedStoreStream myStream;
    private int locator = 0;
    private long streamLength = -1L;
    private final int streamPositionOffset;
    private boolean isValid = true;
    private LOBStreamControl control;

    EmbedBlob(byte[] blobBytes, EmbedConnection con) throws SQLException {
        super(con);
        try {
            this.control = new LOBStreamControl(con, blobBytes);
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            con.addLOBReference(this);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    protected EmbedBlob(DataValueDescriptor dvd, EmbedConnection con) throws StandardException, SQLException {
        super(con);
        SanityManager.ASSERT((!dvd.isNull() ? 1 : 0) != 0, (String)"blob is created on top of a null column");
        if (dvd.hasStream()) {
            this.streamPositionOffset = this.handleStreamValue(dvd.getStream(), con);
        } else {
            this.materialized = true;
            this.streamPositionOffset = Integer.MIN_VALUE;
            byte[] dvdBytes = dvd.getBytes();
            SanityManager.ASSERT((dvdBytes != null ? 1 : 0) != 0, (String)"blob has a null value underneath");
            try {
                this.control = new LOBStreamControl(this.getEmbedConnection(), dvdBytes);
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
        }
        con.addLOBReference(this);
    }

    private int handleStreamValue(InputStream dvdStream, EmbedConnection con) throws StandardException, SQLException {
        int offset = 0;
        if (dvdStream instanceof Resetable) {
            this.materialized = false;
            SanityManager.ASSERT((boolean)(dvdStream instanceof Resetable));
            try {
                this.myStream = new PositionedStoreStream(dvdStream);
                BinaryToRawStream tmpStream = new BinaryToRawStream(this.myStream, con);
                offset = (int)this.myStream.getPosition();
                this.streamLength = tmpStream.getLength();
                tmpStream.close();
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("40XD0")) {
                    throw StandardException.newException((String)"XJ073.S", (Object[])new Object[0]);
                }
                throw se;
            }
            catch (IOException ioe) {
                throw StandardException.newException((String)"XCL30.S", (Throwable)ioe, (Object[])new Object[]{"BLOB"});
            }
        }
        SanityManager.ASSERT((boolean)(dvdStream instanceof RawToBinaryFormatStream), (String)("Invalid stream type: " + dvdStream.getClass()));
        this.materialized = true;
        offset = Integer.MIN_VALUE;
        try {
            int read;
            this.control = new LOBStreamControl(this.getEmbedConnection());
            BinaryToRawStream tmpStream = new BinaryToRawStream(dvdStream, con);
            byte[] bytes = new byte[4096];
            long pos = 0L;
            while ((read = tmpStream.read(bytes, 0, bytes.length)) >= 1) {
                pos = this.control.write(bytes, 0, read, pos);
            }
            tmpStream.close();
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
        return offset;
    }

    private long setBlobPosition(long logicalPos) throws StandardException, IOException {
        SanityManager.ASSERT((logicalPos >= 0L ? 1 : 0) != 0);
        if (this.materialized) {
            if (logicalPos >= this.control.getLength()) {
                throw StandardException.newException((String)"XJ076.S", (Object[])new Object[]{logicalPos});
            }
        } else {
            try {
                this.myStream.reposition(logicalPos + (long)this.streamPositionOffset);
            }
            catch (EOFException eofe) {
                throw StandardException.newException((String)"XJ076.S", (Throwable)eofe, (Object[])new Object[]{logicalPos});
            }
        }
        return logicalPos;
    }

    private int read(long pos) throws IOException, StandardException {
        int c;
        if (this.materialized) {
            if (pos >= this.control.getLength()) {
                return -1;
            }
            c = this.control.read(pos);
        } else {
            this.myStream.reposition(pos + (long)this.streamPositionOffset);
            c = this.myStream.read();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                return this.control.getLength();
            }
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        if (this.streamLength != -1L) {
            return this.streamLength;
        }
        boolean pushStack = false;
        try {
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    EmbedConnection ec = this.getEmbedConnection();
                    boolean bl = pushStack = !ec.isClosed();
                    if (pushStack) {
                        this.setupContextStack();
                    }
                    this.myStream.resetStream();
                    BinaryToRawStream tmpStream = new BinaryToRawStream(this.myStream, this);
                    SanityManager.ASSERT((tmpStream.getLength() == -1 ? 1 : 0) != 0);
                    this.streamLength = InputStreamUtil.skipUntilEOF(tmpStream);
                    tmpStream.close();
                    EmbedBlob.restoreIntrFlagIfSeen(pushStack, ec);
                    long l = this.streamLength;
                    return l;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw this.handleMyExceptions(t);
                    }
                }
            }
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long startPos, int length) throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            byte[] result;
            if (startPos < 1L) {
                throw StandardException.newException((String)"XJ070.S", (Object[])new Object[]{startPos});
            }
            if (length < 0) {
                throw StandardException.newException((String)"XJ071.S", (Object[])new Object[]{length});
            }
            if (this.materialized) {
                result = new byte[length];
                int sz = this.control.read(result, 0, result.length, startPos - 1L);
                if (sz == -1) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                if (sz < length) {
                    byte[] tmparray = new byte[sz];
                    System.arraycopy(result, 0, tmparray, 0, sz);
                    result = tmparray;
                }
                InterruptStatus.restoreIntrFlagIfSeen();
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    EmbedConnection ec;
                    block21: {
                        ec = this.getEmbedConnection();
                        boolean bl = pushStack = !ec.isClosed();
                        if (pushStack) {
                            this.setupContextStack();
                        }
                        this.setBlobPosition(startPos - 1L);
                        result = new byte[length];
                        int n = InputStreamUtil.readLoop(this.myStream, result, 0, length);
                        if (n >= length) break block21;
                        byte[] result2 = new byte[n];
                        System.arraycopy(result, 0, result2, 0, n);
                        EmbedBlob.restoreIntrFlagIfSeen(pushStack, ec);
                        byte[] byArray = result2;
                        return byArray;
                    }
                    EmbedBlob.restoreIntrFlagIfSeen(pushStack, ec);
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (StandardException e) {
            if (e.getMessageId().equals("XJ079.S")) {
                e = StandardException.newException((String)"XJ076.S", (Object[])new Object[]{startPos});
            }
            throw this.handleMyExceptions(e);
        }
        catch (Throwable t) {
            throw this.handleMyExceptions(t);
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            if (this.materialized) {
                InputStream result;
                InputStream inputStream = result = this.control.getInputStream(0L);
                return inputStream;
            }
            Object result = this.getConnectionSynchronization();
            synchronized (result) {
                try {
                    EmbedConnection ec = this.getEmbedConnection();
                    boolean bl = pushStack = !ec.isClosed();
                    if (pushStack) {
                        this.setupContextStack();
                    }
                    this.myStream.resetStream();
                    UpdatableBlobStream result2 = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                    EmbedBlob.restoreIntrFlagIfSeen(pushStack, ec);
                    UpdatableBlobStream updatableBlobStream = result2;
                    return updatableBlobStream;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw this.handleMyExceptions(t);
                    }
                }
            }
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] pattern, long pos) throws IOException, StandardException {
        for (int i = 1; i < pattern.length; ++i) {
            int b;
            if ((b = this.read(pos++)) >= 0 && b == pattern[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long position(Blob pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob pattern, long pos) throws IOException, StandardException {
        int b2;
        InputStream pStream;
        try {
            pStream = pattern.getBinaryStream();
        }
        catch (SQLException e) {
            return false;
        }
        if (pStream == null) {
            return false;
        }
        int b1 = pStream.read();
        if (b1 < 0) {
            return false;
        }
        do {
            if ((b1 = pStream.read()) >= 0) continue;
            return true;
        } while (b1 == (b2 = this.read(pos++)) && b2 >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable t) throws SQLException {
        if (t instanceof StandardException && ((StandardException)t).getMessageId().equals("40XD0")) {
            t = StandardException.newException((String)"XJ073.S", (Object[])new Object[0]);
        }
        return this.handleException(t);
    }

    protected void finalize() {
        if (!this.materialized) {
            this.myStream.closeStream();
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkValidity();
        if (pos - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", pos);
        }
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        if (offset < 0 || offset > bytes.length) {
            throw Util.generateCsSQLException("XJ078.S", offset);
        }
        if (len < 0) {
            throw Util.generateCsSQLException("XJ071.S", len);
        }
        if (len == 0) {
            return 0;
        }
        if (len > bytes.length - offset) {
            throw Util.generateCsSQLException("XJ079.S", len);
        }
        try {
            if (this.materialized) {
                this.control.write(bytes, offset, len, pos - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, this.length());
                this.control.write(bytes, offset, len, pos - 1L);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
            return len;
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidity();
        if (pos - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", pos);
        }
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(pos - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection());
            this.control.copyData(this.myStream, pos - 1L);
            this.myStream.close();
            this.streamLength = -1L;
            this.materialized = true;
            return this.control.getOutputStream(pos - 1L);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (len > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", len);
        }
        try {
            if (this.materialized) {
                this.control.truncate(len);
            } else {
                this.setBlobPosition(0L);
                this.control = new LOBStreamControl(this.getEmbedConnection());
                this.control.copyData(this.myStream, len);
                this.myStream.close();
                this.streamLength = -1L;
                this.materialized = true;
            }
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    @Override
    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        if (this.locator != 0) {
            this.localConn.removeLOBMapping(this.locator);
        }
        this.streamLength = -1L;
        if (!this.materialized) {
            this.myStream.closeStream();
            this.myStream = null;
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", pos);
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", length);
        }
        if (length > this.length() - (pos - 1L)) {
            throw Util.generateCsSQLException("XJ087.S", pos, length);
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), pos - 1L, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw EmbedBlob.newSQLException("XJ215.S", new Object[0]);
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }

    @Override
    public int getLocator() {
        if (this.locator == 0) {
            this.locator = this.localConn.addLOBMapping(this);
        }
        return this.locator;
    }
}

