/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.RecordComponentVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.TypeReference;
import org.jruby.org.objectweb.asm.tree.ClassNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jruby.org.objectweb.asm.tree.analysis.Analyzer;
import org.jruby.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jruby.org.objectweb.asm.tree.analysis.BasicValue;
import org.jruby.org.objectweb.asm.tree.analysis.Frame;
import org.jruby.org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.jruby.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jruby.org.objectweb.asm.util.CheckFieldAdapter;
import org.jruby.org.objectweb.asm.util.CheckMethodAdapter;
import org.jruby.org.objectweb.asm.util.CheckModuleAdapter;
import org.jruby.org.objectweb.asm.util.CheckRecordComponentAdapter;
import org.jruby.org.objectweb.asm.util.Textifier;
import org.jruby.org.objectweb.asm.util.TraceMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private static final String USAGE = "Verifies the given class.\nUsage: CheckClassAdapter <fully qualified class name or class file name>";
    private static final String ERROR_AT = ": error at index ";
    private boolean checkDataFlow;
    private int version;
    private boolean visitCalled;
    private boolean visitModuleCalled;
    private boolean visitSourceCalled;
    private boolean visitOuterClassCalled;
    private boolean visitNestHostCalled;
    private String nestMemberPackageName;
    private boolean visitEndCalled;
    private Map<Label, Integer> labelInsnIndices = new HashMap<Label, Integer>();

    public CheckClassAdapter(ClassVisitor classVisitor) {
        this(classVisitor, true);
    }

    public CheckClassAdapter(ClassVisitor classVisitor, boolean checkDataFlow) {
        this(589824, classVisitor, checkDataFlow);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int api, ClassVisitor classVisitor, boolean checkDataFlow) {
        super(api, classVisitor);
        this.checkDataFlow = checkDataFlow;
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        if (this.visitCalled) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.visitCalled = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 259633);
        if (name2 == null) {
            throw new IllegalArgumentException("Illegal class name (null)");
        }
        if (!name2.endsWith("package-info") && !name2.endsWith("module-info")) {
            CheckMethodAdapter.checkInternalName(version, name2, "class name");
        }
        if ("java/lang/Object".equals(name2)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else if (name2.endsWith("module-info")) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of a module-info class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(version, superName, "super class name");
        }
        if (signature != null) {
            CheckClassAdapter.checkClassSignature(signature);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces2 != null) {
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                CheckMethodAdapter.checkInternalName(version, interfaces2[i2], "interface name at index " + i2);
            }
        }
        this.version = version;
        super.visit(version, access, name2, signature, superName, interfaces2);
    }

    @Override
    public void visitSource(String file2, String debug) {
        this.checkState();
        if (this.visitSourceCalled) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.visitSourceCalled = true;
        super.visitSource(file2, debug);
    }

    @Override
    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.checkState();
        if (this.visitModuleCalled) {
            throw new IllegalStateException("visitModule can be called only once.");
        }
        this.visitModuleCalled = true;
        CheckClassAdapter.checkFullyQualifiedName(this.version, name2, "module name");
        CheckClassAdapter.checkAccess(access, 36896);
        CheckModuleAdapter checkModuleAdapter = new CheckModuleAdapter(this.api, super.visitModule(name2, access, version), (access & 0x20) != 0);
        checkModuleAdapter.classVersion = this.version;
        return checkModuleAdapter;
    }

    @Override
    public void visitNestHost(String nestHost) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, nestHost, "nestHost");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitNestHost can be called only once.");
        }
        if (this.nestMemberPackageName != null) {
            throw new IllegalStateException("visitNestHost and visitNestMember are mutually exclusive.");
        }
        this.visitNestHostCalled = true;
        super.visitNestHost(nestHost);
    }

    @Override
    public void visitNestMember(String nestMember) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, nestMember, "nestMember");
        if (this.visitNestHostCalled) {
            throw new IllegalStateException("visitMemberOfNest and visitNestHost are mutually exclusive.");
        }
        String packageName = CheckClassAdapter.packageName(nestMember);
        if (this.nestMemberPackageName == null) {
            this.nestMemberPackageName = packageName;
        } else if (!this.nestMemberPackageName.equals(packageName)) {
            throw new IllegalStateException("nest member " + nestMember + " should be in the package " + this.nestMemberPackageName);
        }
        super.visitNestMember(nestMember);
    }

    @Override
    public void visitPermittedSubclass(String permittedSubclass) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, permittedSubclass, "permittedSubclass");
        super.visitPermittedSubclass(permittedSubclass);
    }

    @Override
    public void visitOuterClass(String owner2, String name2, String descriptor) {
        this.checkState();
        if (this.visitOuterClassCalled) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.visitOuterClassCalled = true;
        if (owner2 == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (descriptor != null) {
            CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        }
        super.visitOuterClass(owner2, name2, descriptor);
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(this.version, name2, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(this.version, outerName, "outer class name");
        }
        if (innerName != null) {
            int startIndex;
            for (startIndex = 0; startIndex < innerName.length() && Character.isDigit(innerName.charAt(startIndex)); ++startIndex) {
            }
            if (startIndex == 0 || startIndex < innerName.length()) {
                CheckMethodAdapter.checkIdentifier(this.version, innerName, startIndex, -1, "inner class name");
            }
        }
        CheckClassAdapter.checkAccess(access, 30239);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
        this.checkState();
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "record component name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        return new CheckRecordComponentAdapter(this.api, super.visitRecordComponent(name2, descriptor, signature));
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 184543);
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "field name");
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        if (value2 != null) {
            CheckMethodAdapter.checkConstant(value2);
        }
        return new CheckFieldAdapter(this.api, super.visitField(access, name2, descriptor, signature, value2));
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkMethodAccess(this.version, access, 171519);
        if (!"<init>".equals(name2) && !"<clinit>".equals(name2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "method name");
        }
        CheckMethodAdapter.checkMethodDescriptor(this.version, descriptor);
        if (signature != null) {
            CheckClassAdapter.checkMethodSignature(signature);
        }
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                CheckMethodAdapter.checkInternalName(this.version, exceptions[i2], "exception name at index " + i2);
            }
        }
        CheckMethodAdapter checkMethodAdapter = this.checkDataFlow ? new CheckMethodAdapter(this.api, access, name2, descriptor, super.visitMethod(access, name2, descriptor, signature, exceptions), this.labelInsnIndices) : new CheckMethodAdapter(this.api, super.visitMethod(access, name2, descriptor, signature, exceptions), this.labelInsnIndices);
        checkMethodAdapter.version = this.version;
        return checkMethodAdapter;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(descriptor, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.checkState();
        int sort2 = new TypeReference(typeRef).getSort();
        if (sort2 != 0 && sort2 != 17 && sort2 != 16) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort2));
        }
        CheckClassAdapter.checkTypeRef(typeRef);
        CheckMethodAdapter.checkDescriptor(this.version, descriptor, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, descriptor, visible));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.checkState();
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.visitCalled) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int publicProtectedPrivate = 7;
        if (Integer.bitCount(access & publicProtectedPrivate) > 1) {
            throw new IllegalArgumentException("public, protected and private are mutually exclusive: " + access);
        }
        if (Integer.bitCount(access & 0x410) > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }

    private static void checkMethodAccess(int version, int access, int possibleAccess) {
        CheckClassAdapter.checkAccess(access, possibleAccess);
        if ((version & 0xFFFF) < 61 && Integer.bitCount(access & 0xC00) > 1) {
            throw new IllegalArgumentException("strictfp and abstract are mutually exclusive: " + access);
        }
    }

    static void checkFullyQualifiedName(int version, String name2, String source2) {
        try {
            int dotIndex;
            int startIndex = 0;
            while ((dotIndex = name2.indexOf(46, startIndex + 1)) != -1) {
                CheckMethodAdapter.checkIdentifier(version, name2, startIndex, dotIndex, null);
                startIndex = dotIndex + 1;
            }
            CheckMethodAdapter.checkIdentifier(version, name2, startIndex, name2.length(), null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + source2 + " (must be a fully qualified name): " + name2, e);
        }
    }

    public static void checkClassSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == 'L') {
            pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ERROR_AT + pos2);
        }
    }

    public static void checkMethodSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkChar('(', signature, pos2);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(signature, pos2)) != -1) {
            pos2 = CheckClassAdapter.checkJavaTypeSignature(signature, pos2);
        }
        pos2 = CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(')', signature, pos2)) == 'V' ? ++pos2 : CheckClassAdapter.checkJavaTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '^') {
            if (CheckClassAdapter.getChar(signature, ++pos2) == 'L') {
                pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
                continue;
            }
            pos2 = CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ERROR_AT + pos2);
        }
    }

    public static void checkFieldSignature(String signature) {
        int pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, 0);
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ERROR_AT + pos2);
        }
    }

    private static int checkTypeParameters(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkTypeParameter(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkTypeParameter(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkTypeParameter(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        if ("L[T".indexOf(CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(':', signature, pos2))) != -1) {
            pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == ':') {
            pos2 = CheckClassAdapter.checkReferenceTypeSignature(signature, pos2 + 1);
        }
        return pos2;
    }

    private static int checkReferenceTypeSignature(String signature, int pos2) {
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(signature, pos2);
            }
            case '[': {
                return CheckClassAdapter.checkJavaTypeSignature(signature, pos2 + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
    }

    private static int checkClassTypeSignature(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('L', signature, pos2);
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '/') {
            pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2 + 1);
        }
        if (CheckClassAdapter.getChar(signature, pos2) == '<') {
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == '.') {
            if (CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2 + 1)) != '<') continue;
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkTypeArguments(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkTypeArgument(String signature, int startPos) {
        int pos2 = startPos;
        char c = CheckClassAdapter.getChar(signature, pos2);
        if (c == '*') {
            return pos2 + 1;
        }
        if (c == '+' || c == '-') {
            ++pos2;
        }
        return CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
    }

    private static int checkTypeVariableSignature(String signature, int startPos) {
        int pos2 = startPos;
        pos2 = CheckClassAdapter.checkChar('T', signature, pos2);
        pos2 = CheckClassAdapter.checkSignatureIdentifier(signature, pos2);
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkJavaTypeSignature(String signature, int startPos) {
        int pos2 = startPos;
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos2 + 1;
            }
        }
        return CheckClassAdapter.checkReferenceTypeSignature(signature, pos2);
    }

    private static int checkSignatureIdentifier(String signature, int startPos) {
        int pos2 = startPos;
        while (pos2 < signature.length() && ".;[/<>:".indexOf(signature.codePointAt(pos2)) == -1) {
            pos2 = signature.offsetByCodePoints(pos2, 1);
        }
        if (pos2 == startPos) {
            throw new IllegalArgumentException(signature + ": identifier expected at index " + startPos);
        }
        return pos2;
    }

    private static int checkChar(char c, String signature, int pos2) {
        if (CheckClassAdapter.getChar(signature, pos2) == c) {
            return pos2 + 1;
        }
        throw new IllegalArgumentException(signature + ": '" + c + "' expected at index " + pos2);
    }

    private static char getChar(String string2, int pos2) {
        return pos2 < string2.length() ? string2.charAt(pos2) : (char)'\u0000';
    }

    static void checkTypeRef(int typeRef) {
        int mask = 0;
        switch (typeRef >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                mask = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                mask = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                mask = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                mask = -16776961;
                break;
            }
        }
        if (mask == 0 || (typeRef & ~mask) != 0) {
            throw new IllegalArgumentException("Invalid type reference 0x" + Integer.toHexString(typeRef));
        }
    }

    private static String packageName(String name2) {
        int index2 = name2.lastIndexOf(47);
        if (index2 == -1) {
            return "";
        }
        return name2.substring(0, index2);
    }

    public static void main(String[] args2) throws IOException {
        CheckClassAdapter.main(args2, new PrintWriter(System.err, true));
    }

    static void main(String[] args2, PrintWriter logger) throws IOException {
        ClassReader classReader;
        block6: {
            block5: {
                if (args2.length != 1) {
                    logger.println(USAGE);
                    return;
                }
                if (!args2[0].endsWith(".class")) break block5;
                FileInputStream inputStream = new FileInputStream(args2[0]);
                try {
                    classReader = new ClassReader(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                    }
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                break block6;
            }
            classReader = new ClassReader(args2[0]);
        }
        CheckClassAdapter.verify(classReader, false, logger);
    }

    public static void verify(ClassReader classReader, boolean printResults, PrintWriter printWriter) {
        CheckClassAdapter.verify(classReader, null, printResults, printWriter);
    }

    public static void verify(ClassReader classReader, ClassLoader loader, boolean printResults, PrintWriter printWriter) {
        ClassNode classNode = new ClassNode();
        classReader.accept(new CheckClassAdapter(0x10A0000, classNode, false){}, 2);
        Type syperType = classNode.superName == null ? null : Type.getObjectType(classNode.superName);
        List<MethodNode> methods2 = classNode.methods;
        ArrayList<Type> interfaces2 = new ArrayList<Type>();
        for (String interfaceName : classNode.interfaces) {
            interfaces2.add(Type.getObjectType(interfaceName));
        }
        for (MethodNode method2 : methods2) {
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType(classNode.name), syperType, interfaces2, (classNode.access & 0x200) != 0);
            Analyzer<BasicValue> analyzer = new Analyzer<BasicValue>(verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                analyzer.analyze(classNode.name, method2);
            }
            catch (AnalyzerException e) {
                e.printStackTrace(printWriter);
            }
            if (!printResults) continue;
            CheckClassAdapter.printAnalyzerResult(method2, analyzer, printWriter);
        }
        printWriter.flush();
    }

    static void printAnalyzerResult(MethodNode method2, Analyzer<BasicValue> analyzer, PrintWriter printWriter) {
        Textifier textifier = new Textifier();
        TraceMethodVisitor traceMethodVisitor = new TraceMethodVisitor(textifier);
        printWriter.println(method2.name + method2.desc);
        for (int i2 = 0; i2 < method2.instructions.size(); ++i2) {
            method2.instructions.get(i2).accept(traceMethodVisitor);
            StringBuilder stringBuilder = new StringBuilder();
            Frame<BasicValue> frame = analyzer.getFrames()[i2];
            if (frame == null) {
                stringBuilder.append('?');
            } else {
                int j;
                for (j = 0; j < frame.getLocals(); ++j) {
                    stringBuilder.append(CheckClassAdapter.getUnqualifiedName(frame.getLocal(j).toString())).append(' ');
                }
                stringBuilder.append(" : ");
                for (j = 0; j < frame.getStackSize(); ++j) {
                    stringBuilder.append(CheckClassAdapter.getUnqualifiedName(frame.getStack(j).toString())).append(' ');
                }
            }
            while (stringBuilder.length() < method2.maxStack + method2.maxLocals + 1) {
                stringBuilder.append(' ');
            }
            printWriter.print(Integer.toString(i2 + 100000).substring(1));
            printWriter.print(" " + stringBuilder + " : " + textifier.text.get(textifier.text.size() - 1));
        }
        for (TryCatchBlockNode tryCatchBlock : method2.tryCatchBlocks) {
            tryCatchBlock.accept(traceMethodVisitor);
            printWriter.print(" " + textifier.text.get(textifier.text.size() - 1));
        }
        printWriter.println();
    }

    private static String getUnqualifiedName(String name2) {
        int lastBracketIndex;
        int lastSlashIndex = name2.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            return name2;
        }
        int endIndex = name2.length();
        if (name2.charAt(endIndex - 1) == ';') {
            --endIndex;
        }
        if ((lastBracketIndex = name2.lastIndexOf(91)) == -1) {
            return name2.substring(lastSlashIndex + 1, endIndex);
        }
        return name2.substring(0, lastBracketIndex + 1) + name2.substring(lastSlashIndex + 1, endIndex);
    }
}

