/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.beaninfo.editors.ServiceTypePanel;
import org.openide.ServiceType;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceTypeEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String PROPERTY_NEW_TYPE = "createNew";
    private static final String PROPERTY_SUPERCLASS = "superClass";
    private String[] tags;
    private Class<? extends ServiceType> clazz;
    private String message;
    private PropertyEnv env;
    private boolean createNewInstance = false;

    public ServiceTypeEditor() {
        this(ServiceType.class, "LAB_ChooseServiceType");
    }

    public ServiceTypeEditor(Class<?> clazz, String string) {
        this.clazz = clazz.asSubclass(ServiceType.class);
        this.message = string;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        this.env = propertyEnv;
        Object object2 = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_NEW_TYPE);
        if (object2 instanceof Boolean) {
            this.createNewInstance = (Boolean)object2;
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue(PROPERTY_SUPERCLASS)) instanceof Class) {
            Class clazz;
            this.clazz = clazz = (Class)object;
        }
    }

    private void updateTags() {
        LinkedList<String> linkedList = new LinkedList<String>();
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration enumeration = registry.services(this.clazz);
        while (enumeration.hasMoreElements()) {
            ServiceType serviceType = (ServiceType)enumeration.nextElement();
            FeatureDescriptor featureDescriptor = null;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(serviceType.getClass());
                featureDescriptor = beanInfo.getBeanDescriptor();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            if (featureDescriptor != null && featureDescriptor.isHidden()) continue;
            linkedList.add(serviceType.getName());
        }
        this.tags = new String[linkedList.size()];
        linkedList.toArray(this.tags);
    }

    @Override
    public String getAsText() {
        if (this.createNewInstance) {
            return null;
        }
        ServiceType serviceType = (ServiceType)this.getValue();
        if (serviceType == null) {
            return ServiceTypeEditor.getString("LAB_DefaultServiceType");
        }
        return serviceType.getName();
    }

    @Override
    public void setAsText(String string) {
        if (this.createNewInstance) {
            throw new IllegalArgumentException();
        }
        ServiceType.Registry registry = (ServiceType.Registry)Lookup.getDefault().lookup(ServiceType.Registry.class);
        Enumeration enumeration = registry.services(this.clazz);
        while (enumeration.hasMoreElements()) {
            ServiceType serviceType = (ServiceType)enumeration.nextElement();
            if (!string.equals(serviceType.getName())) continue;
            this.setValue(serviceType);
            return;
        }
        this.setValue(null);
    }

    @Override
    public String[] getTags() {
        if (!this.createNewInstance) {
            this.updateTags();
            return this.tags;
        }
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        final ServiceTypePanel serviceTypePanel = new ServiceTypePanel(this.clazz, ServiceTypeEditor.getString(this.message), null, this.createNewInstance);
        serviceTypePanel.setServiceType((ServiceType)this.getValue());
        serviceTypePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("serviceType".equals(propertyChangeEvent.getPropertyName())) {
                    ServiceTypeEditor.this.setValue(serviceTypePanel.getServiceType());
                }
            }
        });
        return serviceTypePanel;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(ServiceTypeEditor.class).getString(string);
    }
}

