#!/usr/bin/perl
# -*- indent-tabs-mode: nil; -*-
# vim:ft=perl:et:sw=4
# $Id: mod2html.pl.in 12576 2015-12-08 11:56:43Z sikeda $

use lib split(/:/, $ENV{SYMPALIB} || ''), '/usr/local/libdata/perl5/site_perl';
use strict;
use warnings;
use English qw(-no_match_vars);

use Conf;
use Sympa::Constants;
use Sympa::Log;
use Sympa::Spool::Moderation;

my $log = Sympa::Log->instance;

unless (Conf::load(Sympa::Constants::CONFIG)) {
    die 'Can\'t load Sympa configuration file';
}
$log->openlog(
    $Conf::Conf{'syslog'},
    $Conf::Conf{'log_socket_type'},
    service => 'sympa/mod2html'
);

# Set the UserID & GroupID for the process
$GID = $EGID = (getgrnam(Sympa::Constants::GROUP))[2];
$UID = $EUID = (getpwnam(Sympa::Constants::USER))[2];

# Sets the UMASK.
umask oct $Conf::Conf{'umask'};

my $spool_mod = Sympa::Spool::Moderation->new;

while (1) {
    my ($message, $handle) = $spool_mod->next(no_lock => 1);
    last unless $handle;
    next unless $message;

    my $context = $message->{context};
    next
        unless ref $context eq 'Sympa::List'
            and $message->{authkey}
            and $message->{authkey} =~ /\A\w+\z/;
    next
        if -f join('/',
        $spool_mod->{html_base_directory}, $context->get_id,
        $message->{authkey},               'msg00000.html');

    printf "Creating HTML version for %s\n", $message->get_id;

    $spool_mod->html_store($message, $message->{authkey});
}

exit 0;

__END__

=encoding utf-8

=head1 NAME

mod2html, mod2html.pl - Generates HTML view of messages to be moderated

=head1 SYNOPSIS

  mod2html.pl

=head1 DESCRIPTION

Until Sympa release 3.4.3.1, HTML view of moderated messages was created by
wwsympa.fgci, when needed.
It is now created by sympa.pl when the message is received.

This script will create all missing HTML files.

=head1 CONFIGURATION PARAMETERS

Following site configuration parameters in F</var/sympa/etc/sympa.conf> will be referred.

=over

=item mhonarc

Path to MHonArc mail-to-HTML converter.

=item queuemod

Directory for moderation spool.

=item viewmail_dir

Directory containing HTML file generated by MHonArc while displaying messages
other than archives.

=back

=head1 HISTORY

mod2html.pl appeared on Sympa 3.4.4.

6.2a.32 or earlier stored HTML view into moderation spool.
6.2b has dedicated directory specified by viewmail_dir parameter.

=cut
