<?php

declare(strict_types=1);

/**
 * @copyright Copyright (c) 2022, Thomas Citharel <nextcloud@tcit.fr>
 *
 * @author Thomas Citharel <nextcloud@tcit.fr>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
namespace OCP\App\Events;

use OCP\EventDispatcher\Event;

/**
 * @since 27.0.0
 */
class AppEnableEvent extends Event {
	private string $appId;
	/** @var string[] */
	private array $groupIds;

	/**
	 * @param string[] $groupIds
	 * @since 27.0.0
	 */
	public function __construct(string $appId, array $groupIds = []) {
		parent::__construct();

		$this->appId = $appId;
		$this->groupIds = $groupIds;
	}

	/**
	 * @since 27.0.0
	 */
	public function getAppId(): string {
		return $this->appId;
	}

	/**
	 * @since 27.0.0
	 */
	public function getGroupIds(): array {
		return $this->groupIds;
	}
}
