/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class ConstraintFactory {
    public void process(DirectoryEntry directoryEntry, ProjectFile projectFile, DocumentInputStreamFactory documentInputStreamFactory) throws IOException {
        DirectoryEntry directoryEntry2;
        try {
            directoryEntry2 = (DirectoryEntry)directoryEntry.getEntry("TBkndCons");
        }
        catch (FileNotFoundException fileNotFoundException) {
            directoryEntry2 = null;
        }
        if (directoryEntry2 != null) {
            FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedMeta")), 10);
            FixedData fixedData = new FixedData(fixedMeta, 20, documentInputStreamFactory.getInstance(directoryEntry2, "FixedData"));
            int n = fixedMeta.getAdjustedItemCount();
            int n2 = -1;
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            EventManager eventManager = projectFile.getEventManager();
            boolean bl = NumberHelper.getInt(projectProperties.getMppFileType()) == 14 && NumberHelper.getInt(projectProperties.getApplicationVersion()) > 14;
            int n3 = bl ? 18 : 14;
            int n4 = bl ? 14 : 16;
            for (int i = 0; i < n; ++i) {
                int n5;
                int n6;
                byte[] byArray;
                int n7;
                byte[] byArray2 = fixedMeta.getByteArrayValue(i);
                if (MPPUtility.getShort(byArray2, 0) != 0 || (n7 = fixedData.getIndexFromOffset(MPPUtility.getInt(byArray2, 4))) == -1 || (byArray = fixedData.getByteArrayValue(n7)).length < 14 || (n6 = MPPUtility.getInt(byArray, 0)) <= n2) continue;
                n2 = n6;
                int n8 = MPPUtility.getInt(byArray, 4);
                if (n8 == (n5 = MPPUtility.getInt(byArray, 8))) continue;
                Task task = projectFile.getTaskByUniqueID(n8);
                Task task2 = projectFile.getTaskByUniqueID(n5);
                if (task == null || task2 == null) continue;
                RelationType relationType = RelationType.getInstance(MPPUtility.getShort(byArray, 12));
                TimeUnit timeUnit = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n3));
                Duration duration = MPPUtility.getAdjustedDuration(projectProperties, MPPUtility.getInt(byArray, n4), timeUnit);
                Relation relation = task2.addPredecessor(task, relationType, duration);
                eventManager.fireRelationReadEvent(relation);
            }
        }
    }
}

