/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.SearchStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SearchFacadeStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream innerStream;

    public SearchFacadeStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        if (collectionName.indexOf(34) > -1) {
            collectionName = collectionName.replaceAll("\"", "").replaceAll(" ", "");
        }
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), new String[]{namedParam.getParameter().toString().trim()});
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        if (mParams.get("qt") != null && mParams.get("qt").equals("/export")) {
            CloudSolrStream cloudSolrStream = new CloudSolrStream();
            cloudSolrStream.init(collectionName, zkHost, (SolrParams)mParams);
            this.innerStream = cloudSolrStream;
        } else {
            if (mParams.get("partitionKeys") != null) {
                throw new IOException("partitionKeys can only be used in the search function when the /export handler is specified");
            }
            SearchStream searchStream = new SearchStream();
            searchStream.init(zkHost, collectionName, mParams);
            this.innerStream = searchStream;
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return ((Expressible)((Object)this.innerStream)).toExpression(factory);
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return this.innerStream.toExplanation(factory);
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.innerStream.setStreamContext(context);
    }

    @Override
    public void open() throws IOException {
        this.innerStream.open();
    }

    @Override
    public List<TupleStream> children() {
        return this.innerStream.children();
    }

    @Override
    public void close() throws IOException {
        this.innerStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.innerStream.read();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.innerStream.getStreamSort();
    }
}

