/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceResolver;
import org.apache.logging.log4j.layout.template.json.util.CharSequencePointer;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.layout.template.json.util.TruncatingBufferedPrintWriter;

final class StackTraceStringResolver
implements StackTraceResolver {
    private final Recycler<TruncatingBufferedPrintWriter> srcWriterRecycler;
    private final Recycler<TruncatingBufferedPrintWriter> dstWriterRecycler;
    private final Recycler<CharSequencePointer> sequencePointerRecycler;
    private final boolean truncationEnabled;
    private final String truncationSuffix;
    private final List<String> truncationPointMatcherStrings;
    private final List<Pattern> groupedTruncationPointMatcherRegexes;

    StackTraceStringResolver(EventResolverContext context, String truncationSuffix, List<String> truncationPointMatcherStrings, List<String> truncationPointMatcherRegexes) {
        Supplier<TruncatingBufferedPrintWriter> writerSupplier = () -> TruncatingBufferedPrintWriter.ofCapacity(context.getMaxStringByteCount());
        RecyclerFactory recyclerFactory = context.getRecyclerFactory();
        this.srcWriterRecycler = recyclerFactory.create(writerSupplier, TruncatingBufferedPrintWriter::close);
        this.dstWriterRecycler = recyclerFactory.create(writerSupplier, TruncatingBufferedPrintWriter::close);
        this.sequencePointerRecycler = recyclerFactory.create(CharSequencePointer::new);
        this.truncationEnabled = !truncationPointMatcherStrings.isEmpty() || !truncationPointMatcherRegexes.isEmpty();
        this.truncationSuffix = truncationSuffix;
        this.truncationPointMatcherStrings = truncationPointMatcherStrings;
        this.groupedTruncationPointMatcherRegexes = StackTraceStringResolver.groupTruncationPointMatcherRegexes(truncationPointMatcherRegexes);
    }

    private static List<Pattern> groupTruncationPointMatcherRegexes(List<String> regexes) {
        return regexes.stream().map(regex -> Pattern.compile(".*?" + regex + "(.*)", 32)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(Throwable throwable, JsonWriter jsonWriter) {
        TruncatingBufferedPrintWriter srcWriter = this.srcWriterRecycler.acquire();
        try {
            throwable.printStackTrace(srcWriter);
            TruncatingBufferedPrintWriter dstWriter = this.truncate(srcWriter);
            jsonWriter.writeString(dstWriter);
        }
        finally {
            this.srcWriterRecycler.release(srcWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TruncatingBufferedPrintWriter truncate(TruncatingBufferedPrintWriter srcWriter) {
        if (!this.truncationEnabled) {
            return srcWriter;
        }
        TruncatingBufferedPrintWriter dstWriter = this.dstWriterRecycler.acquire();
        try {
            CharSequencePointer sequencePointer = this.sequencePointerRecycler.acquire();
            try {
                this.truncate(srcWriter, dstWriter, sequencePointer);
            }
            finally {
                this.sequencePointerRecycler.release(sequencePointer);
            }
        }
        finally {
            this.dstWriterRecycler.release(dstWriter);
        }
        return dstWriter;
    }

    private void truncate(TruncatingBufferedPrintWriter srcWriter, TruncatingBufferedPrintWriter dstWriter, CharSequencePointer sequencePointer) {
        int startIndex = 0;
        while (true) {
            char c;
            int labeledLineStartIndex;
            int endIndex;
            int truncationPointIndex;
            if ((truncationPointIndex = this.findTruncationPointIndex(srcWriter, startIndex, endIndex = (labeledLineStartIndex = StackTraceStringResolver.findLabeledLineStartIndex(srcWriter, startIndex, srcWriter.length())) >= 0 ? labeledLineStartIndex : srcWriter.length(), sequencePointer)) > 0) {
                dstWriter.append(srcWriter, startIndex, truncationPointIndex);
                dstWriter.append(System.lineSeparator());
                dstWriter.append(this.truncationSuffix);
            } else {
                dstWriter.append(srcWriter, startIndex, endIndex);
            }
            if (labeledLineStartIndex <= 0) break;
            dstWriter.append(System.lineSeparator());
            startIndex = labeledLineStartIndex;
            do {
                c = srcWriter.charAt(startIndex++);
                dstWriter.append(c);
            } while (c != ':');
        }
    }

    private int findTruncationPointIndex(TruncatingBufferedPrintWriter writer, int startIndex, int endIndex, CharSequencePointer sequencePointer) {
        CharSequence sequence;
        for (int i = 0; i < this.truncationPointMatcherStrings.size(); ++i) {
            String matcher = this.truncationPointMatcherStrings.get(i);
            int matchIndex = StackTraceStringResolver.findMatchingIndex(matcher, writer, startIndex, endIndex);
            if (matchIndex <= 0) continue;
            return matchIndex + matcher.length();
        }
        if (startIndex == 0 && endIndex == writer.length()) {
            sequence = writer;
        } else {
            sequencePointer.reset(writer, startIndex, writer.length());
            sequence = sequencePointer;
        }
        for (int i = 0; i < this.groupedTruncationPointMatcherRegexes.size(); ++i) {
            Pattern pattern = this.groupedTruncationPointMatcherRegexes.get(i);
            Matcher matcher = pattern.matcher(sequence);
            boolean matched = matcher.matches();
            if (!matched) continue;
            int lastGroup = matcher.groupCount();
            return matcher.start(lastGroup);
        }
        return -1;
    }

    private static int findLabeledLineStartIndex(CharSequence buffer, int startIndex, int endIndex) {
        int lineStartIndex;
        int bufferIndex = startIndex;
        while (bufferIndex < endIndex && (lineStartIndex = StackTraceStringResolver.findLineStartIndex(buffer, bufferIndex, endIndex)) >= 0) {
            for (bufferIndex = lineStartIndex; bufferIndex < endIndex && '\t' == buffer.charAt(bufferIndex); ++bufferIndex) {
            }
            if (bufferIndex < endIndex - 11 && buffer.charAt(bufferIndex) == 'C' && buffer.charAt(bufferIndex + 1) == 'a' && buffer.charAt(bufferIndex + 2) == 'u' && buffer.charAt(bufferIndex + 3) == 's' && buffer.charAt(bufferIndex + 4) == 'e' && buffer.charAt(bufferIndex + 5) == 'd' && buffer.charAt(bufferIndex + 6) == ' ' && buffer.charAt(bufferIndex + 7) == 'b' && buffer.charAt(bufferIndex + 8) == 'y' && buffer.charAt(bufferIndex + 9) == ':' && buffer.charAt(bufferIndex + 10) == ' ') {
                return lineStartIndex;
            }
            if (bufferIndex >= endIndex - 12 || buffer.charAt(bufferIndex) != 'S' || buffer.charAt(bufferIndex + 1) != 'u' || buffer.charAt(bufferIndex + 2) != 'p' || buffer.charAt(bufferIndex + 3) != 'p' || buffer.charAt(bufferIndex + 4) != 'r' || buffer.charAt(bufferIndex + 5) != 'e' || buffer.charAt(bufferIndex + 6) != 's' || buffer.charAt(bufferIndex + 7) != 's' || buffer.charAt(bufferIndex + 8) != 'e' || buffer.charAt(bufferIndex + 9) != 'd' || buffer.charAt(bufferIndex + 10) != ':' || buffer.charAt(bufferIndex + 11) != ' ') continue;
            return lineStartIndex;
        }
        return -1;
    }

    private static int findLineStartIndex(CharSequence buffer, int startIndex, int endIndex) {
        int prevChar = 45;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (prevChar == 10) {
                return i;
            }
            prevChar = buffer.charAt(i);
        }
        return -1;
    }

    private static int findMatchingIndex(CharSequence matcher, CharSequence buffer, int bufferStartIndex, int bufferEndIndex) {
        int effectiveBufferEndIndex = bufferEndIndex - matcher.length() + 1;
        for (int bufferIndex = bufferStartIndex; bufferIndex <= effectiveBufferEndIndex; ++bufferIndex) {
            boolean found = true;
            for (int matcherIndex = 0; matcherIndex < matcher.length(); ++matcherIndex) {
                char bufferChar;
                char matcherChar = matcher.charAt(matcherIndex);
                if (matcherChar == (bufferChar = buffer.charAt(bufferIndex + matcherIndex))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return bufferIndex;
        }
        return -1;
    }
}

