/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.carrot2.util.StringUtils;

public class GlobDictionary
implements Predicate<CharSequence> {
    private final Function<String, String> tokenNormalization;
    private final Function<CharSequence, String[]> termSplitter;
    private Map<String, List<WordPattern>> tokenToPatterns;
    private Map<Integer, List<WordPattern>> pureTypePatterns;

    public GlobDictionary(Stream<WordPattern> patterns, Function<String, String> tokenNormalization, Function<CharSequence, String[]> termSplitter) {
        this.tokenNormalization = tokenNormalization;
        this.termSplitter = termSplitter;
        this.compile(patterns, tokenNormalization);
    }

    public GlobDictionary(Stream<WordPattern> patterns) {
        this(patterns, GlobDictionary.defaultTokenNormalization(), GlobDictionary.defaultTermSplitter());
    }

    public static Function<CharSequence, String[]> defaultTermSplitter() {
        return chs -> {
            String seq = chs.toString();
            ArrayList<String> tokens = new ArrayList<String>();
            int p = 0;
            int max = seq.length();
            while (p < max) {
                while (p < max && seq.charAt(p) == ' ') {
                    ++p;
                }
                int s = p;
                while (p < max && seq.charAt(p) != ' ') {
                    ++p;
                }
                if (s >= p) continue;
                tokens.add(seq.substring(s, p));
            }
            return (String[])tokens.toArray(String[]::new);
        };
    }

    @Override
    public boolean test(CharSequence input) {
        String[] inputTerms = this.split(input);
        String[] normalizedTerms = this.normalize(inputTerms);
        return this.find(inputTerms, normalizedTerms, null, p -> true);
    }

    public boolean find(String[] inputTerms, String[] normalizedTerms, int[] types, Predicate<WordPattern> earlyAbort) {
        boolean found = false;
        for (String normalizedToken : normalizedTerms) {
            List<WordPattern> patterns = this.tokenToPatterns.get(normalizedToken);
            if (patterns == null) continue;
            for (WordPattern pattern : patterns) {
                if (!pattern.matches(inputTerms, normalizedTerms, types)) continue;
                found = true;
                if (!earlyAbort.test(pattern)) continue;
                return found;
            }
        }
        if (!this.pureTypePatterns.isEmpty() && types != null) {
            int allTypeBits = 0;
            for (int type : types) {
                allTypeBits |= type;
            }
            Object object = this.pureTypePatterns.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry e = (Map.Entry)object.next();
                int bitField = (Integer)e.getKey();
                if ((bitField & allTypeBits) != bitField) continue;
                for (WordPattern pattern : (List)e.getValue()) {
                    if (!pattern.matches(inputTerms, normalizedTerms, types)) continue;
                    found = true;
                    if (!earlyAbort.test(pattern)) continue;
                    return found;
                }
            }
        }
        return found;
    }

    public String[] split(CharSequence input) {
        return this.termSplitter.apply(input);
    }

    public String[] normalize(String[] tokens) {
        String[] normalized = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            normalized[i] = this.tokenNormalization.apply(tokens[i]);
        }
        return normalized;
    }

    public String toString() {
        return "GlobDictionary: " + this.tokenToPatterns;
    }

    private void compile(Stream<WordPattern> patterns, Function<String, String> tokenNormalization) {
        HashMap cache = new HashMap();
        Function<String, String> normalize = s -> {
            String normalized = (String)tokenNormalization.apply((String)s);
            return cache.computeIfAbsent(normalized, x -> normalized);
        };
        patterns = patterns.peek(GlobDictionary::checkInvalid);
        patterns = patterns.map(pattern -> {
            ArrayList<Token> modifiedTokens = new ArrayList<Token>(pattern.tokens.size());
            boolean hadChanges = false;
            for (Token t : pattern.tokens()) {
                if (t.matchType == MatchType.NORMALIZED) {
                    hadChanges = true;
                    modifiedTokens.add(new Token((String)normalize.apply(t.image), t.matchType, t.typeBits));
                    continue;
                }
                modifiedTokens.add(t);
            }
            return hadChanges ? new WordPattern(modifiedTokens, pattern.payload) : pattern;
        });
        patterns = patterns.sorted();
        HashMap<String, List<WordPattern>> tokenToPatterns = new HashMap<String, List<WordPattern>>();
        HashMap<Integer, List<WordPattern>> pureTypePatterns = new HashMap<Integer, List<WordPattern>>();
        patterns.forEach(pattern -> {
            HashSet<Object> useKey = new HashSet<Object>();
            boolean indexed = false;
            for (Token t : pattern.tokens) {
                if (!t.matchType.isIndexable() || t.matchType == MatchType.ANY_OF_TYPE) continue;
                indexed = true;
                String key = t.matchType == MatchType.NORMALIZED ? t.image : (String)normalize.apply(t.image);
                if (!useKey.add(key)) continue;
                tokenToPatterns.computeIfAbsent(key, k -> new ArrayList()).add(pattern);
            }
            if (!indexed) {
                for (Token t : pattern.tokens) {
                    int key;
                    if (t.matchType != MatchType.ANY_OF_TYPE || !useKey.add(key = t.typeBits)) continue;
                    pureTypePatterns.computeIfAbsent(key, k -> new ArrayList()).add(pattern);
                }
            }
        });
        assert (this.noDuplicateRules(tokenToPatterns.values()));
        assert (this.noDuplicateRules(pureTypePatterns.values()));
        this.tokenToPatterns = tokenToPatterns;
        this.pureTypePatterns = pureTypePatterns;
    }

    private boolean noDuplicateRules(Collection<List<WordPattern>> values) {
        values.forEach(v -> {
            Set unique = Collections.newSetFromMap(new IdentityHashMap());
            unique.addAll(values);
            if (unique.size() != values.size()) {
                throw new AssertionError((Object)"Duplicate rules detected.");
            }
        });
        return true;
    }

    private static void checkInvalid(WordPattern pattern) {
        if (pattern.tokens().isEmpty()) {
            throw new IllegalArgumentException("Empty pattern is not valid.");
        }
        if (pattern.tokens().stream().noneMatch(t -> t.matchType.isIndexable())) {
            throw new IllegalArgumentException("A wildcard-only pattern is not valid: " + pattern);
        }
    }

    public static Function<String, String> defaultTokenNormalization() {
        return s -> s.toLowerCase(Locale.ROOT);
    }

    public static GlobDictionary compilePatterns(Stream<String> entries) {
        PatternParser parser = new PatternParser();
        ArrayList errors = new ArrayList();
        AtomicInteger warningsEmitted = new AtomicInteger();
        Stream<WordPattern> compiled = entries.filter(pattern -> !StringUtils.isNullOrEmpty(pattern.trim())).map(pattern -> {
            try {
                return parser.parse((String)pattern);
            }
            catch (ParseException e) {
                if (warningsEmitted.get() < 10) {
                    StringBuilder positionMark = new StringBuilder();
                    int errorOffset = e.getErrorOffset();
                    if (errorOffset >= 0) {
                        positionMark.append((String)pattern);
                        positionMark.setLength(errorOffset);
                        positionMark.insert(errorOffset, "<here>");
                        positionMark.insert(0, ", at: ");
                    }
                    errors.add("Could not parse pattern: " + pattern + positionMark + ", reason: " + e.getMessage() + (warningsEmitted.incrementAndGet() == 10 ? " (any following warnings suppressed)" : ""));
                }
                return null;
            }
        }).filter(Objects::nonNull);
        if (!errors.isEmpty()) {
            throw new RuntimeException("Dictionary compilation errors occurred:\n" + errors.stream().map(e -> "  - " + e + ",\n").collect(Collectors.joining()));
        }
        return new GlobDictionary(compiled);
    }

    public static class PatternParser {
        static final Token ZERO_OR_MORE_POSSESSIVE = new Token("*", MatchType.ZERO_OR_MORE_POSSESSIVE, 0);
        static final Token ZERO_OR_MORE_RELUCTANT = new Token("*?", MatchType.ZERO_OR_MORE_RELUCTANT, 0);
        static final Token ANY = new Token("?", MatchType.ANY, 0);
        private final Map<String, Integer> typeMap;

        public PatternParser() {
            this(Collections.emptyMap());
        }

        public PatternParser(Map<String, Integer> typeMap) {
            this.typeMap = typeMap;
        }

        public WordPattern parse(String pattern) throws ParseException {
            return this.parse(pattern, null);
        }

        public WordPattern parse(String pattern, Object payload) throws ParseException {
            ArrayList<Token> tokens = new ArrayList<Token>();
            int pos = 0;
            int max = pattern.length();
            block7: while (pos != max) {
                char chr = pattern.charAt(pos);
                switch (chr) {
                    case '?': {
                        tokens.add(ANY);
                        pos = this.spaceOrEnd(pattern, pos + 1);
                        continue block7;
                    }
                    case '+': {
                        if (this.isReluctant(pattern, pos + 1)) {
                            this.noConsecutiveWildcards(pattern, ++pos, tokens);
                            tokens.add(ANY);
                            tokens.add(ZERO_OR_MORE_RELUCTANT);
                        } else {
                            this.noConsecutiveWildcards(pattern, pos, tokens);
                            tokens.add(ANY);
                            tokens.add(ZERO_OR_MORE_POSSESSIVE);
                        }
                        pos = this.spaceOrEnd(pattern, pos + 1);
                        continue block7;
                    }
                    case '*': {
                        if (this.isReluctant(pattern, pos + 1)) {
                            this.noConsecutiveWildcards(pattern, ++pos, tokens);
                            tokens.add(ZERO_OR_MORE_RELUCTANT);
                            pos = this.spaceOrEnd(pattern, pos + 1);
                            continue block7;
                        }
                        this.noConsecutiveWildcards(pattern, pos, tokens);
                        tokens.add(ZERO_OR_MORE_POSSESSIVE);
                        pos = this.spaceOrEnd(pattern, pos + 1);
                        continue block7;
                    }
                    case '\t': 
                    case ' ': {
                        ++pos;
                        continue block7;
                    }
                    case '\"': 
                    case '\'': {
                        pos = this.parseQuoted(pattern, chr, pos + 1, tokens);
                        pos = this.spaceOrEnd(pattern, pos);
                        continue block7;
                    }
                }
                pos = this.parseUnquoted(pattern, pos, tokens);
            }
            this.handleInvalid(tokens);
            return new WordPattern(tokens, payload);
        }

        private boolean isReluctant(String pattern, int pos) {
            return pos < pattern.length() && pattern.charAt(pos) == '?';
        }

        private void noConsecutiveWildcards(String pattern, int pos, ArrayList<Token> tokens) throws ParseException {
            if (tokens.size() > 0) {
                switch (tokens.get((int)(tokens.size() - 1)).matchType) {
                    case ZERO_OR_MORE_RELUCTANT: 
                    case ZERO_OR_MORE_POSSESSIVE: {
                        throw new ParseException("Consecutive wildcards not supported: " + pattern, pos);
                    }
                }
            }
        }

        private void handleInvalid(ArrayList<Token> tokens) throws ParseException {
            if (tokens.size() == 0) {
                throw new ParseException("Empty patterns not allowed.", -1);
            }
            if (tokens.stream().noneMatch(t -> t.matchType.isIndexable())) {
                throw new ParseException("Wildcard-only patterns are invalid.", -1);
            }
        }

        private int spaceOrEnd(String pattern, int pos) throws ParseException {
            if (pattern.length() == pos) {
                return pos;
            }
            switch (pattern.charAt(pos)) {
                case '\t': 
                case ' ': {
                    return pos + 1;
                }
            }
            throw new ParseException("Expected a whitespace or end of pattern.", pos);
        }

        private int parseUnquoted(String pattern, int pos, ArrayList<Token> tokens) throws ParseException {
            StringBuilder sb = new StringBuilder();
            int max = pattern.length();
            block6: while (pos < max) {
                switch (pattern.charAt(pos)) {
                    case '\t': 
                    case ' ': {
                        break block6;
                    }
                    case '\"': {
                        throw new ParseException("Unescaped quote inside.", pos);
                    }
                    case '*': {
                        throw new ParseException("Wildcard is a special character. Quote if necessary.", pos);
                    }
                    case '\\': {
                        if (++pos == max) {
                            throw new ParseException("Terminating escape quote character.", pos - 1);
                        }
                        sb.append(pattern.charAt(pos));
                        break;
                    }
                    default: {
                        sb.append(pattern.charAt(pos));
                    }
                }
                ++pos;
            }
            String image = sb.toString();
            if (!this.typeMap.isEmpty() && image.startsWith("{") && image.endsWith("}")) {
                int typeBits = 0;
                for (String type : image.substring(1, image.length() - 1).split("\\s*&\\s*")) {
                    if (!this.typeMap.containsKey(type)) {
                        throw new ParseException("Type name not recognized in pattern '" + pattern + "': " + type + ", expected one of: " + new TreeSet<String>(this.typeMap.keySet()), pos);
                    }
                    typeBits |= this.typeMap.get(type).intValue();
                }
                tokens.add(new Token(image, MatchType.ANY_OF_TYPE, typeBits));
            } else {
                tokens.add(new Token(image, MatchType.NORMALIZED, 0));
            }
            return pos;
        }

        private int parseQuoted(String pattern, char openingQuote, int pos, ArrayList<Token> tokens) throws ParseException {
            StringBuilder sb = new StringBuilder();
            int max = pattern.length();
            int quoteStart = pos;
            while (pos < max) {
                char chr = pattern.charAt(pos);
                switch (chr) {
                    case '\"': 
                    case '\'': {
                        if (openingQuote == chr) {
                            tokens.add(new Token(sb.toString(), MatchType.VERBATIM, 0));
                            return ++pos;
                        }
                        sb.append(pattern.charAt(pos));
                        break;
                    }
                    case '\\': {
                        if (++pos == max) {
                            throw new ParseException("Terminating escape quote character.", pos - 1);
                        }
                        sb.append(pattern.charAt(pos));
                        break;
                    }
                    default: {
                        sb.append(pattern.charAt(pos));
                    }
                }
                ++pos;
            }
            throw new ParseException("Pattern ended (unbalanced quote).", quoteStart - 1);
        }
    }

    public static final class Token
    implements Comparable<Token> {
        final MatchType matchType;
        final String image;
        final int typeBits;

        public Token(String image, MatchType matchType, int typeBits) {
            this.matchType = matchType;
            this.image = image;
            this.typeBits = typeBits;
        }

        @Override
        public int compareTo(Token other) {
            int v = this.image.compareTo(other.image);
            if (v == 0) {
                v = this.matchType.compareTo(other.matchType);
            }
            if (v == 0) {
                v = Integer.compare(this.typeBits, other.typeBits);
            }
            return v;
        }

        public String image() {
            return this.image;
        }

        public MatchType matchType() {
            return this.matchType;
        }

        public String toString() {
            switch (this.matchType()) {
                case NORMALIZED: 
                case ANY_OF_TYPE: {
                    return this.image();
                }
                case VERBATIM: {
                    return "'" + this.image() + "'";
                }
                case ZERO_OR_MORE_POSSESSIVE: {
                    assert (this.image().equals("*"));
                    return "*";
                }
                case ZERO_OR_MORE_RELUCTANT: {
                    assert (this.image().equals("*?"));
                    return "*";
                }
                case ANY: {
                    assert (this.image().equals("?"));
                    return "?";
                }
            }
            throw new RuntimeException();
        }

        public int hashCode() {
            return this.image.hashCode() + 31 * this.matchType.ordinal() + 31 * this.typeBits;
        }

        public boolean equals(Object obj) {
            return this.getClass().isInstance(obj) && this.compareTo((Token)obj) == 0;
        }

        public boolean hasType(int tokenType) {
            return (tokenType & this.typeBits) == this.typeBits;
        }
    }

    public static enum MatchType {
        ZERO_OR_MORE_POSSESSIVE,
        ZERO_OR_MORE_RELUCTANT,
        ANY,
        ANY_OF_TYPE,
        VERBATIM,
        NORMALIZED;


        boolean isIndexable() {
            return this == VERBATIM || this == NORMALIZED || this == ANY_OF_TYPE;
        }
    }

    public static final class WordPattern
    implements Comparable<WordPattern> {
        private static final EnumSet<MatchType> FIXED_POSITION = EnumSet.of(MatchType.ANY_OF_TYPE, MatchType.ANY, MatchType.NORMALIZED, MatchType.VERBATIM);
        private final Object payload;
        private final int concreteTokens;
        private final List<Token> tokens;
        private final MatchPredicate matchTest;

        public <T> T getPayload() {
            return (T)this.payload;
        }

        public WordPattern(List<Token> tokens) {
            this(tokens, null);
        }

        public WordPattern(List<Token> tokens, Object payload) {
            if (tokens.isEmpty()) {
                throw new RuntimeException("Empty patterns not allowed.");
            }
            this.payload = payload;
            this.concreteTokens = (int)tokens.stream().filter(t -> FIXED_POSITION.contains((Object)t.matchType)).count();
            this.tokens = this.getClass().desiredAssertionStatus() ? Collections.unmodifiableList(tokens) : tokens;
            this.matchTest = this.determineMatchTest(tokens);
        }

        private MatchPredicate determineMatchTest(List<Token> tokens) {
            int tokenCount = tokens.size();
            if (this.concreteTokens == tokenCount) {
                return this::matchFixedSequence;
            }
            int rightConcrete = this.countRightFixedTokens(tokens);
            if (rightConcrete > 0) {
                return (verbatim, normalized, types) -> {
                    if (verbatim.length < this.concreteTokens) {
                        return false;
                    }
                    int tokMax = verbatim.length;
                    int tokIdx = tokMax - rightConcrete;
                    int patMax = tokenCount;
                    int patIdx = patMax - rightConcrete;
                    return this.matchSubrange(verbatim, normalized, types, tokIdx, tokMax, patIdx, patMax) && this.matchCheckFull(verbatim, normalized, types);
                };
            }
            return this::matchCheckFull;
        }

        private int countRightFixedTokens(List<Token> tokens) {
            int count = 0;
            int i = tokens.size();
            while (--i >= 0 && FIXED_POSITION.contains((Object)tokens.get((int)i).matchType)) {
                ++count;
            }
            return count;
        }

        public List<Token> tokens() {
            return this.tokens;
        }

        public String toString() {
            return this.tokens.toString();
        }

        public int hashCode() {
            return this.tokens.hashCode();
        }

        public boolean equals(Object obj) {
            return this.getClass().isInstance(obj) && this.compareTo((WordPattern)obj) == 0;
        }

        @Override
        public int compareTo(WordPattern other) {
            List<Token> t1 = this.tokens;
            List<Token> t2 = other.tokens;
            int max = Math.min(t1.size(), t2.size());
            for (int i = 0; i < max; ++i) {
                int v = t1.get(i).compareTo(t2.get(i));
                if (v == 0) continue;
                return v;
            }
            return Integer.compare(t1.size(), t2.size());
        }

        public boolean matches(String[] verbatimTerms, String[] normalizedTerms, int[] types) {
            return this.matchTest.matches(verbatimTerms, normalizedTerms, types);
        }

        private boolean matchFixedSequence(String[] verbatimTerms, String[] normalizedTerms, int[] type) {
            if (this.tokens.size() != verbatimTerms.length) {
                return false;
            }
            for (int i = 0; i < verbatimTerms.length; ++i) {
                if (this.tokenMatches(this.tokens.get(i), verbatimTerms[i], normalizedTerms[i], type == null ? 0 : type[i])) continue;
                return false;
            }
            return true;
        }

        private boolean matchCheckFull(String[] verbatimTerms, String[] normalizedTerms, int[] types) {
            if (verbatimTerms.length < this.concreteTokens) {
                return false;
            }
            List<Token> patternTokens = this.tokens();
            assert (patternTokens.size() >= 1);
            assert (verbatimTerms.length == normalizedTerms.length);
            assert (verbatimTerms.length >= 1);
            int tIndex = 0;
            int pIndex = 0;
            int tMax = verbatimTerms.length;
            int pMax = patternTokens.size();
            return this.matchSubrange(verbatimTerms, normalizedTerms, types, tIndex, tMax, pIndex, pMax);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean matchSubrange(String[] verbatim, String[] normalized, int[] types, int tokIdx, int tokMax, int patIdx, int patMax) {
            List<Token> patternTokens = this.tokens();
            block7: while (true) {
                block19: {
                    Token nextToken;
                    if (patIdx == patMax) {
                        if (tokIdx != tokMax) return false;
                        return true;
                    }
                    Token pToken = patternTokens.get(patIdx);
                    switch (pToken.matchType) {
                        case NORMALIZED: {
                            if (tokIdx == tokMax) return false;
                            if (!pToken.image.equals(normalized[tokIdx])) {
                                return false;
                            }
                            ++patIdx;
                            ++tokIdx;
                            continue block7;
                        }
                        case VERBATIM: {
                            if (tokIdx == tokMax) return false;
                            if (!pToken.image.equals(verbatim[tokIdx])) {
                                return false;
                            }
                            ++patIdx;
                            ++tokIdx;
                            continue block7;
                        }
                        case ANY_OF_TYPE: {
                            if (tokIdx == tokMax) return false;
                            if (!pToken.hasType(types == null ? 0 : types[tokIdx])) {
                                return false;
                            }
                            ++patIdx;
                            ++tokIdx;
                            continue block7;
                        }
                        case ANY: {
                            if (tokIdx == tokMax) {
                                return false;
                            }
                            ++patIdx;
                            ++tokIdx;
                            continue block7;
                        }
                        case ZERO_OR_MORE_RELUCTANT: 
                        case ZERO_OR_MORE_POSSESSIVE: {
                            boolean reluctant;
                            if (patIdx + 1 == patMax) {
                                return true;
                            }
                            nextToken = patternTokens.get(++patIdx);
                            if (!$assertionsDisabled) {
                                if (nextToken.matchType == MatchType.ZERO_OR_MORE_RELUCTANT) throw new AssertionError();
                                if (nextToken.matchType == MatchType.ZERO_OR_MORE_POSSESSIVE) {
                                    throw new AssertionError();
                                }
                            }
                            boolean bl = reluctant = pToken.matchType == MatchType.ZERO_OR_MORE_RELUCTANT;
                            if (reluctant) break;
                            int min = tokIdx;
                            tokIdx = tokMax;
                            for (int i = tokMax - 1; i >= min; --i) {
                                if (!this.tokenMatches(nextToken, verbatim[i], normalized[i], types == null ? 0 : types[i])) continue;
                                tokIdx = i;
                                break block19;
                            }
                            break block19;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    while (tokIdx < tokMax && !this.tokenMatches(nextToken, verbatim[tokIdx], normalized[tokIdx], types == null ? 0 : types[tokIdx])) {
                        ++tokIdx;
                    }
                }
                if (tokIdx == tokMax) {
                    return false;
                }
                ++patIdx;
                ++tokIdx;
            }
        }

        private boolean tokenMatches(Token token, String verbatim, String normalized, int type) {
            switch (token.matchType) {
                case ANY: {
                    return true;
                }
                case ANY_OF_TYPE: {
                    return token.hasType(type);
                }
                case NORMALIZED: {
                    return token.image.equals(normalized);
                }
                case VERBATIM: {
                    return token.image.equals(verbatim);
                }
            }
            throw new AssertionError((Object)("Unexpected token type: " + token));
        }

        private static interface MatchPredicate {
            public boolean matches(String[] var1, String[] var2, int[] var3);
        }
    }
}

