/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Arrays;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.LinearConverter;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;

final class Prefixes {
    private static final String DECA = "da";
    private static final char[] PREFIXES = new char[]{'E', 'G', 'M', 'P', 'T', 'Y', 'Z', 'a', 'c', 'd', 'f', 'h', 'k', 'm', 'n', 'p', 'y', 'z', '\u00b5', '\u03bc', '\u3372'};
    private static final byte[] POWERS = new byte[]{18, 9, 6, 15, 12, 24, 21, -18, -2, -1, -15, 2, 3, -3, -9, -12, -24, -21, -6, -6, 1};
    private static final char[] ENUM = new char[]{'y', 'z', 'a', 'f', 'p', 'n', '\u00b5', 'm', 'c', 'd', '\u3372', 'h', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    static final int MAX_POWER = 8;
    private static final LinearConverter[] CONVERTERS = new LinearConverter[POWERS.length];

    private Prefixes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinearConverter converter(char c) {
        int n = Arrays.binarySearch(PREFIXES, c);
        if (n < 0) {
            return null;
        }
        LinearConverter[] linearConverterArray = CONVERTERS;
        synchronized (CONVERTERS) {
            LinearConverter linearConverter = CONVERTERS[n];
            if (linearConverter == null) {
                double d;
                double d2;
                byte by = POWERS[n];
                if (by >= 0) {
                    d2 = MathFunctions.pow10(by);
                    d = 1.0;
                } else {
                    d2 = 1.0;
                    d = MathFunctions.pow10(-by);
                }
                Prefixes.CONVERTERS[n] = linearConverter = LinearConverter.scale(d2, d);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return linearConverter;
        }
    }

    static char symbol(double d, int n) {
        switch (n) {
            case 0: {
                return '\u0000';
            }
            case 1: {
                break;
            }
            case 2: {
                d = Math.sqrt(d);
                break;
            }
            case 3: {
                d = Math.cbrt(d);
                break;
            }
            default: {
                d = Math.pow(d, 1.0 / (double)n);
            }
        }
        int n2 = Numerics.toExp10(Math.getExponent(d)) + 1;
        if (AbstractConverter.epsilonEquals(MathFunctions.pow10(n2), d)) {
            int n3 = Math.abs(n2);
            switch (n3) {
                case 0: {
                    return '\u0000';
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (n3 > 24 || n3 % 3 != 0) {
                        return '\u0000';
                    }
                    n3 = n3 / 3 + 2;
                }
            }
            return ENUM[n2 >= 0 ? 9 + n3 : 10 - n3];
        }
        return '\u0000';
    }

    static String concat(char c, String string) {
        return c == '\u3372' ? DECA + string : c + string;
    }

    static Unit<?> getUnit(String string) {
        Unit<?> unit = Units.get(string);
        if (unit == null && string.length() >= 2) {
            String string2;
            int n;
            LinearConverter linearConverter;
            int n2 = 1;
            char c = string.charAt(0);
            if (c == 'd' && string.charAt(1) == 'a') {
                c = '\u3372';
                n2 = 2;
            }
            if (AbstractUnit.isPrefixable(unit = Units.get(string.substring(n2))) && (linearConverter = Prefixes.converter(c)) != null && (n = ConventionalUnit.power(string2 = unit.getSymbol())) != 0) {
                if (n != 1) {
                    linearConverter = LinearConverter.pow(linearConverter, n, false);
                }
                string2 = Prefixes.concat(c, string2);
                return new ConventionalUnit((AbstractUnit)unit, linearConverter, string2.intern(), 0, 0);
            }
            unit = null;
        }
        return unit;
    }

    static <Q extends Quantity<Q>> ConventionalUnit<Q> pseudoSystemUnit(SystemUnit<Q> systemUnit) {
        if ((systemUnit.scope & 0xFFFFFFFD) == 0 && systemUnit.dimension.numeratorIs('M')) {
            if (systemUnit == Units.KILOGRAM) {
                return (ConventionalUnit)Units.GRAM;
            }
            String string = systemUnit.getSymbol();
            if (string != null && string.length() >= 3 && string.startsWith("kg") && !AbstractUnit.isSymbolChar(string.codePointAt(2))) {
                string = string.substring(1);
                LinearConverter linearConverter = Prefixes.converter('m');
                return new ConventionalUnit<Q>(systemUnit, linearConverter, string, 1, 0).unique(string);
            }
        }
        return null;
    }
}

