/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.apache.zookeeper.client.ConnectStringParser;

public class SolrClientFactory {
    private PrometheusExporterSettings settings;

    public SolrClientFactory(PrometheusExporterSettings settings) {
        this.settings = settings;
    }

    public Http2SolrClient createStandaloneSolrClient(String solrHost) {
        Http2SolrClient http2SolrClient = new Http2SolrClient.Builder(solrHost).withIdleTimeout((long)this.settings.getHttpReadTimeout(), TimeUnit.MILLISECONDS).withConnectionTimeout((long)this.settings.getHttpConnectionTimeout(), TimeUnit.MILLISECONDS).withResponseParser((ResponseParser)new NoOpResponseParser("json")).build();
        return http2SolrClient;
    }

    public CloudSolrClient createCloudSolrClient(String zookeeperConnectionString) {
        ConnectStringParser parser = new ConnectStringParser(zookeeperConnectionString);
        CloudHttp2SolrClient client = new CloudHttp2SolrClient.Builder(parser.getServerAddresses().stream().map(address -> address.getHostString() + ":" + address.getPort()).collect(Collectors.toList()), Optional.ofNullable(parser.getChrootPath())).withInternalClientBuilder(new Http2SolrClient.Builder().withIdleTimeout((long)this.settings.getHttpReadTimeout(), TimeUnit.MILLISECONDS).withConnectionTimeout((long)this.settings.getHttpConnectionTimeout(), TimeUnit.MILLISECONDS)).withResponseParser((ResponseParser)new NoOpResponseParser("json")).build();
        client.connect();
        return client;
    }
}

