/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.common.SolrException;

public class CloudConfig {
    private final String zkHost;
    private final int zkClientTimeout;
    private final int hostPort;
    private final String hostName;
    private final String hostContext;
    private final boolean useGenericCoreNames;
    private final int leaderVoteWait;
    private final int leaderConflictResolveWait;
    private final String zkCredentialsProviderClass;
    private final String zkACLProviderClass;
    private final String zkCredentialsInjectorClass;
    private final int createCollectionWaitTimeTillActive;
    private final boolean createCollectionCheckLeaderActive;
    private final String pkiHandlerPrivateKeyPath;
    private final String pkiHandlerPublicKeyPath;
    private final boolean useDistributedClusterStateUpdates;
    private final boolean useDistributedCollectionConfigSetExecution;
    private final int minStateByteLenForCompression;
    private final String stateCompressorClass;

    CloudConfig(String zkHost, int zkClientTimeout, int hostPort, String hostName, String hostContext, boolean useGenericCoreNames, int leaderVoteWait, int leaderConflictResolveWait, String zkCredentialsProviderClass, String zkACLProviderClass, String zkCredentialsInjectorClass, int createCollectionWaitTimeTillActive, boolean createCollectionCheckLeaderActive, String pkiHandlerPrivateKeyPath, String pkiHandlerPublicKeyPath, boolean useDistributedClusterStateUpdates, boolean useDistributedCollectionConfigSetExecution, int minStateByteLenForCompression, String stateCompressorClass) {
        this.zkHost = zkHost;
        this.zkClientTimeout = zkClientTimeout;
        this.hostPort = hostPort;
        this.hostName = hostName;
        this.hostContext = hostContext;
        this.useGenericCoreNames = useGenericCoreNames;
        this.leaderVoteWait = leaderVoteWait;
        this.leaderConflictResolveWait = leaderConflictResolveWait;
        this.zkCredentialsProviderClass = zkCredentialsProviderClass;
        this.zkACLProviderClass = zkACLProviderClass;
        this.zkCredentialsInjectorClass = zkCredentialsInjectorClass;
        this.createCollectionWaitTimeTillActive = createCollectionWaitTimeTillActive;
        this.createCollectionCheckLeaderActive = createCollectionCheckLeaderActive;
        this.pkiHandlerPrivateKeyPath = pkiHandlerPrivateKeyPath;
        this.pkiHandlerPublicKeyPath = pkiHandlerPublicKeyPath;
        this.useDistributedClusterStateUpdates = useDistributedClusterStateUpdates;
        this.useDistributedCollectionConfigSetExecution = useDistributedCollectionConfigSetExecution;
        this.minStateByteLenForCompression = minStateByteLenForCompression;
        this.stateCompressorClass = stateCompressorClass;
        if (useDistributedCollectionConfigSetExecution && !useDistributedClusterStateUpdates) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'useDistributedCollectionConfigSetExecution' can't be true if useDistributedClusterStateUpdates is false");
        }
        if (this.hostPort == -1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'hostPort' must be configured to run SolrCloud");
        }
        if (this.hostContext == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'hostContext' must be configured to run SolrCloud");
        }
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public int getSolrHostPort() {
        return this.hostPort;
    }

    public String getSolrHostContext() {
        return this.hostContext;
    }

    public String getHost() {
        return this.hostName;
    }

    public String getZkCredentialsProviderClass() {
        return this.zkCredentialsProviderClass;
    }

    public String getZkACLProviderClass() {
        return this.zkACLProviderClass;
    }

    public String getZkCredentialsInjectorClass() {
        return this.zkCredentialsInjectorClass;
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public int getLeaderConflictResolveWait() {
        return this.leaderConflictResolveWait;
    }

    public boolean getGenericCoreNodeNames() {
        return this.useGenericCoreNames;
    }

    public int getCreateCollectionWaitTimeTillActive() {
        return this.createCollectionWaitTimeTillActive;
    }

    public boolean isCreateCollectionCheckLeaderActive() {
        return this.createCollectionCheckLeaderActive;
    }

    public String getPkiHandlerPrivateKeyPath() {
        return this.pkiHandlerPrivateKeyPath;
    }

    public String getPkiHandlerPublicKeyPath() {
        return this.pkiHandlerPublicKeyPath;
    }

    public boolean getDistributedClusterStateUpdates() {
        return this.useDistributedClusterStateUpdates;
    }

    public boolean getDistributedCollectionConfigSetExecution() {
        return this.useDistributedCollectionConfigSetExecution;
    }

    public int getMinStateByteLenForCompression() {
        return this.minStateByteLenForCompression;
    }

    public String getStateCompressorClass() {
        return this.stateCompressorClass;
    }

    public static class CloudConfigBuilder {
        private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 45000;
        private static final int DEFAULT_LEADER_VOTE_WAIT = 180000;
        private static final int DEFAULT_LEADER_CONFLICT_RESOLVE_WAIT = 180000;
        private static final int DEFAULT_CREATE_COLLECTION_ACTIVE_WAIT = 45;
        private static final boolean DEFAULT_CREATE_COLLECTION_CHECK_LEADER_ACTIVE = false;
        private static final int DEFAULT_MINIMUM_STATE_SIZE_FOR_COMPRESSION = -1;
        private String zkHost;
        private int zkClientTimeout = Integer.getInteger("zkClientTimeout", 45000);
        private final int hostPort;
        private final String hostName;
        private final String hostContext;
        private boolean useGenericCoreNames;
        private int leaderVoteWait = 180000;
        private int leaderConflictResolveWait = 180000;
        private String zkCredentialsProviderClass;
        private String zkACLProviderClass;
        private String zkCredentialsInjectorClass;
        private int createCollectionWaitTimeTillActive = 45;
        private boolean createCollectionCheckLeaderActive = false;
        private String pkiHandlerPrivateKeyPath;
        private String pkiHandlerPublicKeyPath;
        private boolean useDistributedClusterStateUpdates = false;
        private boolean useDistributedCollectionConfigSetExecution = false;
        private int minStateByteLenForCompression = -1;
        private String stateCompressorClass;

        public CloudConfigBuilder(String hostName, int hostPort) {
            this(hostName, hostPort, null);
        }

        public CloudConfigBuilder(String hostName, int hostPort, String hostContext) {
            this.hostName = hostName;
            this.hostPort = hostPort;
            this.hostContext = hostContext;
        }

        public CloudConfigBuilder setZkHost(String zkHost) {
            this.zkHost = zkHost;
            return this;
        }

        public CloudConfigBuilder setZkClientTimeout(int zkClientTimeout) {
            this.zkClientTimeout = zkClientTimeout;
            return this;
        }

        public CloudConfigBuilder setUseGenericCoreNames(boolean useGenericCoreNames) {
            this.useGenericCoreNames = useGenericCoreNames;
            return this;
        }

        public CloudConfigBuilder setLeaderVoteWait(int leaderVoteWait) {
            this.leaderVoteWait = leaderVoteWait;
            return this;
        }

        public CloudConfigBuilder setLeaderConflictResolveWait(int leaderConflictResolveWait) {
            this.leaderConflictResolveWait = leaderConflictResolveWait;
            return this;
        }

        public CloudConfigBuilder setZkCredentialsProviderClass(String zkCredentialsProviderClass) {
            this.zkCredentialsProviderClass = zkCredentialsProviderClass != null ? zkCredentialsProviderClass.trim() : null;
            return this;
        }

        public CloudConfigBuilder setZkACLProviderClass(String zkACLProviderClass) {
            this.zkACLProviderClass = zkACLProviderClass != null ? zkACLProviderClass.trim() : null;
            return this;
        }

        public CloudConfigBuilder setZkCredentialsInjectorClass(String zkCredentialsInjectorClass) {
            this.zkCredentialsInjectorClass = zkCredentialsInjectorClass != null ? zkCredentialsInjectorClass.trim() : null;
            return this;
        }

        public CloudConfigBuilder setCreateCollectionWaitTimeTillActive(int createCollectionWaitTimeTillActive) {
            this.createCollectionWaitTimeTillActive = createCollectionWaitTimeTillActive;
            return this;
        }

        public CloudConfigBuilder setCreateCollectionCheckLeaderActive(boolean createCollectionCheckLeaderActive) {
            this.createCollectionCheckLeaderActive = createCollectionCheckLeaderActive;
            return this;
        }

        public CloudConfigBuilder setPkiHandlerPrivateKeyPath(String pkiHandlerPrivateKeyPath) {
            this.pkiHandlerPrivateKeyPath = pkiHandlerPrivateKeyPath;
            return this;
        }

        public CloudConfigBuilder setPkiHandlerPublicKeyPath(String pkiHandlerPublicKeyPath) {
            this.pkiHandlerPublicKeyPath = pkiHandlerPublicKeyPath;
            return this;
        }

        public CloudConfigBuilder setUseDistributedClusterStateUpdates(boolean useDistributedClusterStateUpdates) {
            this.useDistributedClusterStateUpdates = useDistributedClusterStateUpdates;
            return this;
        }

        public CloudConfigBuilder setUseDistributedCollectionConfigSetExecution(boolean useDistributedCollectionConfigSetExecution) {
            this.useDistributedCollectionConfigSetExecution = useDistributedCollectionConfigSetExecution;
            return this;
        }

        public CloudConfigBuilder setMinStateByteLenForCompression(int minStateByteLenForCompression) {
            this.minStateByteLenForCompression = minStateByteLenForCompression;
            return this;
        }

        public CloudConfigBuilder setStateCompressorClass(String stateCompressorClass) {
            this.stateCompressorClass = stateCompressorClass;
            return this;
        }

        public CloudConfig build() {
            return new CloudConfig(this.zkHost, this.zkClientTimeout, this.hostPort, this.hostName, this.hostContext, this.useGenericCoreNames, this.leaderVoteWait, this.leaderConflictResolveWait, this.zkCredentialsProviderClass, this.zkACLProviderClass, this.zkCredentialsInjectorClass, this.createCollectionWaitTimeTillActive, this.createCollectionCheckLeaderActive, this.pkiHandlerPrivateKeyPath, this.pkiHandlerPublicKeyPath, this.useDistributedClusterStateUpdates, this.useDistributedCollectionConfigSetExecution, this.minStateByteLenForCompression, this.stateCompressorClass);
        }
    }
}

