/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import org.apache.solr.core.PluginBag;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.jersey.RequestContextKeys;
import org.apache.solr.jersey.SolrJerseyResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMetricHandling {

    public static class PostRequestMetricsFilter
    implements ContainerResponseFilter {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (requestContext.getPropertyNames().contains("RESOURCE_NOT_FOUND")) {
                return;
            }
            RequestHandlerBase.HandlerMetrics metrics = (RequestHandlerBase.HandlerMetrics)requestContext.getProperty(RequestContextKeys.HANDLER_METRICS);
            if (metrics == null) {
                return;
            }
            if (responseContext.hasEntity() && SolrJerseyResponse.class.isInstance(responseContext.getEntity())) {
                SolrJerseyResponse response = (SolrJerseyResponse)responseContext.getEntity();
                if (Boolean.TRUE.equals(response.responseHeader.partialResults)) {
                    metrics.numTimeouts.mark();
                }
            } else {
                log.debug("Skipping partialResults check because entity was not SolrJerseyResponse");
            }
            Timer.Context timer = (Timer.Context)requestContext.getProperty(RequestContextKeys.TIMER);
            metrics.totalTime.inc(timer.stop());
        }
    }

    public static class PreRequestMetricsFilter
    implements ContainerRequestFilter {
        private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        @Context
        private ResourceInfo resourceInfo;

        public void filter(ContainerRequestContext requestContext) throws IOException {
            PluginBag.JaxrsResourceToHandlerMappings requestHandlerByJerseyResource = (PluginBag.JaxrsResourceToHandlerMappings)requestContext.getProperty(RequestContextKeys.RESOURCE_TO_RH_MAPPING);
            if (requestHandlerByJerseyResource == null) {
                log.debug("No jax-rs registry found for request {}", (Object)requestContext);
                return;
            }
            RequestHandlerBase handlerBase = (RequestHandlerBase)requestHandlerByJerseyResource.get(this.resourceInfo.getResourceClass());
            if (handlerBase == null) {
                log.debug("No handler found for request {}", (Object)requestContext);
                return;
            }
            SolrQueryRequest solrQueryRequest = (SolrQueryRequest)requestContext.getProperty(RequestContextKeys.SOLR_QUERY_REQUEST);
            RequestHandlerBase.HandlerMetrics metrics = handlerBase.getMetricsForThisRequest(solrQueryRequest);
            requestContext.setProperty(RequestContextKeys.HANDLER_METRICS, (Object)metrics);
            requestContext.setProperty(RequestContextKeys.TIMER, (Object)metrics.requestTimes.time());
            metrics.requests.inc();
        }
    }
}

