/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import com.google.common.base.Strings;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.request.beans.PackagePayload;
import org.apache.solr.client.solrj.request.beans.PluginMeta;
import org.apache.solr.client.solrj.response.V2Response;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.apache.solr.filestore.DistribPackageStore;
import org.apache.solr.packagemanager.PackageUtils;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.packagemanager.SolrPackageInstance;
import org.apache.solr.util.SolrCLI;
import org.apache.solr.util.SolrVersion;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManager
implements Closeable {
    final String solrBaseUrl;
    final HttpSolrClient solrClient;
    final SolrZkClient zkClient;
    private Map<String, List<SolrPackageInstance>> packages = null;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PackageManager(HttpSolrClient solrClient, String solrBaseUrl, String zkHost) {
        this.solrBaseUrl = solrBaseUrl;
        this.solrClient = solrClient;
        this.zkClient = new SolrZkClient.Builder().withUrl(zkHost).withTimeout(30000, TimeUnit.MILLISECONDS).build();
        log.info("Done initializing a zkClient instance...");
    }

    @Override
    public void close() throws IOException {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
    }

    public void uninstall(String packageName, String version) {
        SolrPackageInstance packageInstance = this.getPackageInstance(packageName, version);
        if (packageInstance == null) {
            PackageUtils.printRed("Package " + packageName + ":" + version + " doesn't exist. Use the install command to install this package version first.");
            System.exit(1);
        }
        Map<String, String> collectionsDeployedOn = this.getDeployedCollections(packageName);
        for (String string : collectionsDeployedOn.keySet()) {
            if (!version.equals(collectionsDeployedOn.get(string))) continue;
            PackageUtils.printRed("Package " + packageName + " is currently deployed on collection: " + string + ". Undeploy the package with undeploy <package-name> -collections <collection1>[,<collection2>,...] before attempting to uninstall the package.");
            System.exit(1);
        }
        Map<String, SolrPackageInstance> clusterPackages = this.getPackagesDeployedAsClusterLevelPlugins();
        for (String clusterPackageName : clusterPackages.keySet()) {
            SolrPackageInstance clusterPackageInstance = clusterPackages.get(clusterPackageName);
            if (!packageName.equals(clusterPackageName) || !version.equals(clusterPackageInstance.version)) continue;
            PackageUtils.printRed("Package " + packageName + "is currently deployed as a cluster-level plugin (" + clusterPackageInstance.getCustomData() + "). Undeploy the package with undeploy <package-name> -collections <collection1>[,<collection2>,...] before uninstalling the package.");
            System.exit(1);
        }
        PackageUtils.printGreen("Executing Package API to remove this package...");
        PackagePayload.DelVersion delVersion = new PackagePayload.DelVersion();
        delVersion.version = version;
        delVersion.pkg = packageName;
        V2Request req = new V2Request.Builder(PackageUtils.PACKAGE_PATH).forceV2(true).withMethod(SolrRequest.METHOD.POST).withPayload(Collections.singletonMap("delete", delVersion)).build();
        try {
            V2Response resp = (V2Response)req.process((SolrClient)this.solrClient);
            PackageUtils.printGreen("Response: " + resp.jsonStr());
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e);
        }
        PackageUtils.printGreen("Executing Package Store API to remove the " + packageName + " package...");
        ArrayList<String> filesToDelete = new ArrayList<String>(packageInstance.files);
        filesToDelete.add(String.format(Locale.ROOT, "/package/%s/%s/%s", packageName, version, "manifest.json"));
        for (String filePath : filesToDelete) {
            DistribPackageStore.deleteZKFileEntry(this.zkClient, filePath);
            String path = this.solrClient.getBaseURL() + "/api/cluster/files" + filePath;
            PackageUtils.printGreen("Deleting " + path);
            HttpDelete httpDel = new HttpDelete(path);
            Utils.executeHttpMethod((HttpClient)this.solrClient.getHttpClient(), (String)path, (Utils.InputStreamConsumer)Utils.JSONCONSUMER, (HttpRequestBase)httpDel);
        }
        PackageUtils.printGreen("Package uninstalled: " + packageName + ":" + version + ":-)");
    }

    public List<SolrPackageInstance> fetchInstalledPackageInstances() throws SolrException {
        log.info("Getting packages from packages.json...");
        ArrayList<SolrPackageInstance> ret = new ArrayList<SolrPackageInstance>();
        this.packages = new HashMap<String, List<SolrPackageInstance>>();
        try {
            if (this.zkClient.exists("/packages.json", true).booleanValue()) {
                Map packagesZnodeMap = (Map)((Map)PackageUtils.getMapper().readValue(new String(this.zkClient.getData("/packages.json", null, null, true), "UTF-8"), Map.class)).get("packages");
                for (String packageName : packagesZnodeMap.keySet()) {
                    List pkg = (List)packagesZnodeMap.get(packageName);
                    for (Map pkgVersion : pkg) {
                        SolrPackage.Manifest manifest = PackageUtils.fetchManifest(this.solrClient, this.solrBaseUrl, pkgVersion.get("manifest").toString(), pkgVersion.get("manifestSHA512").toString());
                        List<SolrPackage.Plugin> solrPlugins = manifest.plugins;
                        SolrPackageInstance pkgInstance = new SolrPackageInstance(packageName, null, pkgVersion.get("version").toString(), manifest, solrPlugins, manifest.parameterDefaults);
                        List files = (List)pkgVersion.get("files");
                        if (files != null) {
                            pkgInstance.files = files;
                        }
                        List list = this.packages.computeIfAbsent(packageName, k -> new ArrayList());
                        list.add(pkgInstance);
                        ret.add(pkgInstance);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        log.info("Got packages: {}", ret);
        return ret;
    }

    public Map<String, SolrPackageInstance> getPackagesDeployed(String collection) {
        Map packages = null;
        try {
            NavigableObject result = (NavigableObject)Utils.executeGET((HttpClient)this.solrClient.getHttpClient(), (String)(this.solrBaseUrl + PackageUtils.getCollectionParamsPath(collection) + "/PKG_VERSIONS?omitHeader=true&wt=javabin"), (Utils.InputStreamConsumer)Utils.JAVABINCONSUMER);
            packages = (Map)result._get("/response/params/PKG_VERSIONS", Collections.emptyMap());
        }
        catch (PathNotFoundException result) {
            // empty catch block
        }
        if (packages == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SolrPackageInstance> ret = new HashMap<String, SolrPackageInstance>();
        for (String packageName : packages.keySet()) {
            if (Strings.isNullOrEmpty((String)packageName) || packages.get(packageName) == null) continue;
            ret.put(packageName, this.getPackageInstance(packageName, (String)packages.get(packageName)));
        }
        return ret;
    }

    public Map<String, SolrPackageInstance> getPackagesDeployedAsClusterLevelPlugins() {
        Map result;
        HashMap<String, String> packageVersions = new HashMap<String, String>();
        HashSetValuedHashMap packagePlugins = new HashSetValuedHashMap();
        try {
            result = (Map)Utils.executeGET((HttpClient)this.solrClient.getHttpClient(), (String)(this.solrBaseUrl + PackageUtils.CLUSTERPROPS_PATH), (Utils.InputStreamConsumer)Utils.JSONCONSUMER);
        }
        catch (SolrException ex) {
            if (ex.code() == SolrException.ErrorCode.NOT_FOUND.code) {
                result = Collections.emptyMap();
            }
            throw ex;
        }
        Map clusterPlugins = result.getOrDefault("plugin", Collections.emptyMap());
        for (String key : clusterPlugins.keySet()) {
            PluginMeta pluginMeta;
            try {
                pluginMeta = (PluginMeta)PackageUtils.getMapper().readValue(Utils.toJSON(clusterPlugins.get(key)), PluginMeta.class);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception while fetching plugins from /clusterprops.json in ZK.", (Throwable)e);
            }
            if (!pluginMeta.klass.contains(":")) continue;
            String packageName = pluginMeta.klass.substring(0, pluginMeta.klass.indexOf(58));
            packageVersions.put(packageName, pluginMeta.version);
            packagePlugins.put((Object)packageName, (Object)pluginMeta);
        }
        HashMap<String, SolrPackageInstance> ret = new HashMap<String, SolrPackageInstance>();
        for (String packageName : packageVersions.keySet()) {
            if (Strings.isNullOrEmpty((String)packageName) || packageVersions.get(packageName) == null) continue;
            ret.put(packageName, this.getPackageInstance(packageName, (String)packageVersions.get(packageName)));
            ((SolrPackageInstance)ret.get(packageName)).setCustomData(packagePlugins.get((Object)packageName));
        }
        return ret;
    }

    private void ensureCollectionsExist(List<String> collections) {
        try {
            List existingCollections = this.zkClient.getChildren("/collections", null, true);
            HashSet<String> nonExistent = new HashSet<String>(collections);
            nonExistent.removeAll(existingCollections);
            if (!nonExistent.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection(s) doesn't exist: " + ((Object)nonExistent).toString());
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to fetch list of collections from ZK.");
        }
    }

    private boolean deployPackage(SolrPackageInstance packageInstance, boolean pegToLatest, boolean isUpdate, boolean noprompt, List<String> collections, boolean shouldDeployClusterPlugins, String[] overrides) {
        boolean clusterSuccess = true;
        if (shouldDeployClusterPlugins) {
            clusterSuccess = this.deployClusterPackage(packageInstance, isUpdate, noprompt, overrides);
        }
        Pair<List<String>, List<String>> deployResult = this.deployCollectionPackage(packageInstance, pegToLatest, isUpdate, noprompt, collections, overrides);
        List deployedCollections = (List)deployResult.first();
        List previouslyDeployedOnCollections = (List)deployResult.second();
        boolean verifySuccess = true;
        verifySuccess = this.verify(packageInstance, deployedCollections, shouldDeployClusterPlugins, overrides);
        if (verifySuccess) {
            PackageUtils.printGreen("Deployed on " + deployedCollections + " and verified package: " + packageInstance.name + ", version: " + packageInstance.version);
        }
        return clusterSuccess && previouslyDeployedOnCollections.isEmpty() && verifySuccess;
    }

    private Pair<List<String>, List<String>> deployCollectionPackage(SolrPackageInstance packageInstance, boolean pegToLatest, boolean isUpdate, boolean noprompt, List<String> collections, String[] overrides) {
        ArrayList<String> previouslyDeployed = new ArrayList<String>();
        for (String collection : collections) {
            SolrPackageInstance deployedPackage = this.getPackagesDeployed(collection).get(packageInstance.name);
            if (packageInstance.equals(deployedPackage)) {
                if (!pegToLatest) {
                    PackageUtils.printRed("Package " + packageInstance + " already deployed on " + collection);
                    previouslyDeployed.add(collection);
                    continue;
                }
            } else if (deployedPackage != null && !isUpdate) {
                PackageUtils.printRed("Package " + deployedPackage + " already deployed on " + collection + ". To update to " + packageInstance + ", pass --update parameter.");
                previouslyDeployed.add(collection);
                continue;
            }
            Map<String, String> collectionParameterOverrides = this.getCollectionParameterOverrides(packageInstance, isUpdate, overrides, collection);
            try {
                boolean packageParamsExist = PackageUtils.getJson(this.solrClient.getHttpClient(), this.solrBaseUrl + PackageUtils.getCollectionParamsPath(collection) + "/packages", Map.class).getOrDefault("response", Collections.emptyMap()).containsKey("params");
                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.getCollectionParamsPath(collection), PackageUtils.getMapper().writeValueAsString(Collections.singletonMap(packageParamsExist ? "update" : "set", Collections.singletonMap("packages", Collections.singletonMap(packageInstance.name, collectionParameterOverrides)))));
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            try {
                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.getCollectionParamsPath(collection), "{set:{PKG_VERSIONS:{" + packageInstance.name + ": '" + (pegToLatest ? "$LATEST" : packageInstance.version) + "'}}}");
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
            }
            if (isUpdate || pegToLatest) {
                try {
                    SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.PACKAGE_PATH, "{\"refresh\": \"" + packageInstance.name + "\"}");
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
                }
            }
            if (!isUpdate) {
                for (SolrPackage.Plugin plugin : packageInstance.plugins) {
                    if (!"collection".equalsIgnoreCase(plugin.type) || collections.isEmpty()) continue;
                    Map<String, String> systemParams = Map.of("collection", collection, "package-name", packageInstance.name, "package-version", packageInstance.version, "plugin-name", plugin.name);
                    SolrPackage.Command cmd = plugin.setupCommand;
                    if (cmd != null && !Strings.isNullOrEmpty((String)cmd.method)) {
                        if ("POST".equalsIgnoreCase(cmd.method)) {
                            try {
                                String payload = PackageUtils.resolve(PackageUtils.getMapper().writeValueAsString(cmd.payload), packageInstance.parameterDefaults, collectionParameterOverrides, systemParams);
                                String path = PackageUtils.resolve(cmd.path, packageInstance.parameterDefaults, collectionParameterOverrides, systemParams);
                                PackageUtils.printGreen("Executing " + payload + " for path:" + path);
                                boolean shouldExecute = this.prompt(noprompt);
                                if (!shouldExecute) continue;
                                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, path, payload);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
                            }
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-POST method not supported for setup commands");
                    }
                    PackageUtils.printRed("There is no setup command to execute for plugin: " + plugin.name);
                }
            }
            try {
                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.getCollectionParamsPath(collection), "{update:{PKG_VERSIONS:{'" + packageInstance.name + "' : '" + (pegToLatest ? "$LATEST" : packageInstance.version) + "'}}}");
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
            }
        }
        if (!previouslyDeployed.isEmpty()) {
            PackageUtils.printRed("Already Deployed on " + previouslyDeployed + ", package: " + packageInstance.name + ", version: " + packageInstance.version);
        }
        List deployedCollections = collections.stream().filter(c -> !previouslyDeployed.contains(c)).collect(Collectors.toList());
        return new Pair(deployedCollections, previouslyDeployed);
    }

    private boolean deployClusterPackage(SolrPackageInstance packageInstance, boolean isUpdate, boolean noprompt, String[] overrides) {
        boolean clusterPluginFailed = false;
        int numberOfClusterPluginsDeployed = 0;
        if (isUpdate) {
            for (SolrPackage.Plugin plugin : packageInstance.plugins) {
                if (!"cluster".equalsIgnoreCase(plugin.type)) continue;
                SolrPackageInstance deployedPackage = this.getPackagesDeployedAsClusterLevelPlugins().get(packageInstance.name);
                if (deployedPackage == null) {
                    PackageUtils.printRed("Cluster level plugin " + plugin.name + " from package " + packageInstance.name + " not deployed. To deploy, remove the --update parameter.");
                    clusterPluginFailed = true;
                    continue;
                }
                for (PluginMeta pluginMeta : (List)deployedPackage.getCustomData()) {
                    PackageUtils.printGreen("Updating this plugin: " + pluginMeta);
                    try {
                        pluginMeta.version = packageInstance.version;
                        String postBody = "{\"update\": " + Utils.toJSONString((Object)pluginMeta) + "}";
                        PackageUtils.printGreen("Posting " + postBody + " to " + PackageUtils.CLUSTER_PLUGINS_PATH);
                        SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.CLUSTER_PLUGINS_PATH, postBody);
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                    }
                }
                ++numberOfClusterPluginsDeployed;
            }
            if (numberOfClusterPluginsDeployed > 0) {
                PackageUtils.printGreen(numberOfClusterPluginsDeployed + " cluster level plugins updated.");
            } else {
                PackageUtils.printRed("No cluster level plugin updated.");
                clusterPluginFailed = true;
            }
        } else {
            for (SolrPackage.Plugin plugin : packageInstance.plugins) {
                Object pkg;
                Map clusterprops;
                block19: {
                    if (!"cluster".equalsIgnoreCase(plugin.type)) continue;
                    clusterprops = null;
                    try {
                        clusterprops = PackageUtils.getJson(this.solrClient.getHttpClient(), this.solrBaseUrl + PackageUtils.CLUSTERPROPS_PATH, Map.class);
                    }
                    catch (SolrException ex) {
                        if (ex.code() == SolrException.ErrorCode.NOT_FOUND.code) break block19;
                        throw ex;
                    }
                }
                if (clusterprops != null && (pkg = clusterprops.getOrDefault("plugin", Collections.emptyMap()).get(packageInstance.name + ":" + plugin.name)) != null) {
                    PackageUtils.printRed("Cluster level plugin " + plugin.name + " from package " + packageInstance.name + " already deployed. To update to " + packageInstance + ", pass --update parameter.");
                    clusterPluginFailed = true;
                    continue;
                }
                Map<String, String> systemParams = Map.of("package-name", packageInstance.name, "package-version", packageInstance.version, "plugin-name", plugin.name);
                SolrPackage.Command cmd = plugin.setupCommand;
                if (cmd != null && !Strings.isNullOrEmpty((String)cmd.method)) {
                    if ("POST".equalsIgnoreCase(cmd.method)) {
                        try {
                            Map<String, String> overridesMap = this.getParameterOverrides(overrides);
                            String payload = PackageUtils.resolve(PackageUtils.getMapper().writeValueAsString(cmd.payload), packageInstance.parameterDefaults, overridesMap, systemParams);
                            String path = PackageUtils.resolve(cmd.path, packageInstance.parameterDefaults, overridesMap, systemParams);
                            PackageUtils.printGreen("Executing " + payload + " for path:" + path);
                            boolean shouldExecute = this.prompt(noprompt);
                            if (!shouldExecute) continue;
                            SolrCLI.postJsonToSolr((SolrClient)this.solrClient, path, payload);
                            ++numberOfClusterPluginsDeployed;
                            continue;
                        }
                        catch (Exception ex) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
                        }
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-POST method not supported for setup commands");
                }
                PackageUtils.printRed("There is no setup command to execute for plugin: " + plugin.name);
            }
            if (numberOfClusterPluginsDeployed > 0) {
                PackageUtils.printGreen(numberOfClusterPluginsDeployed + " cluster level plugins setup.");
            } else {
                PackageUtils.printRed("No cluster level plugin setup.");
                clusterPluginFailed = true;
            }
        }
        return !clusterPluginFailed;
    }

    private boolean prompt(boolean noprompt) {
        boolean shouldExecute = true;
        if (!noprompt) {
            PackageUtils.print(PackageUtils.YELLOW, "Execute this command. (If you choose no, you can manually deploy/undeploy this plugin later) (y/n): ");
            try (Scanner scanner = new Scanner(System.in, "UTF-8");){
                String userInput = scanner.next();
                if ("no".trim().equalsIgnoreCase(userInput) || "n".trim().equalsIgnoreCase(userInput)) {
                    shouldExecute = false;
                    PackageUtils.printRed("Skipping setup command for deploying (deployment verification may fail). Please run this step manually or refer to package documentation.");
                }
            }
        }
        return shouldExecute;
    }

    private Map<String, String> getParameterOverrides(String[] overrides) {
        return this.getCollectionParameterOverrides(null, false, overrides, null);
    }

    private Map<String, String> getCollectionParameterOverrides(SolrPackageInstance packageInstance, boolean isUpdate, String[] overrides, String collection) {
        HashMap<String, String> collectionParameterOverrides;
        Map<String, String> map = collectionParameterOverrides = isUpdate ? this.getPackageParams(packageInstance.name, collection) : new HashMap<String, String>();
        if (overrides != null) {
            for (String override : overrides) {
                collectionParameterOverrides.put(override.split("=")[0], override.split("=")[1]);
            }
        }
        return collectionParameterOverrides;
    }

    Map<String, String> getPackageParams(String packageName, String collection) {
        try {
            return (Map)((Map)((Map)((Map)PackageUtils.getJson(this.solrClient.getHttpClient(), this.solrBaseUrl + PackageUtils.getCollectionParamsPath(collection) + "/packages", Map.class).get("response")).get("params")).get("packages")).get(packageName);
        }
        catch (Exception ex) {
            return Collections.emptyMap();
        }
    }

    public boolean verify(SolrPackageInstance pkg, List<String> collections, boolean shouldDeployClusterPlugins, String[] overrides) {
        boolean success = true;
        for (SolrPackage.Plugin plugin : pkg.plugins) {
            SolrPackage.Command cmd = plugin.verifyCommand;
            if (plugin.verifyCommand == null || Strings.isNullOrEmpty((String)cmd.path)) continue;
            if ("cluster".equalsIgnoreCase(plugin.type)) {
                if (!shouldDeployClusterPlugins) continue;
                Map<String, String> overridesMap = this.getParameterOverrides(overrides);
                Map<String, String> systemParams = Map.of("package-name", pkg.name, "package-version", pkg.version, "plugin-name", plugin.name);
                String url = this.solrBaseUrl + PackageUtils.resolve(cmd.path, pkg.parameterDefaults, overridesMap, systemParams);
                PackageUtils.printGreen("Executing " + url + " for cluster level plugin");
                if ("GET".equalsIgnoreCase(cmd.method)) {
                    String response = PackageUtils.getJsonStringFromUrl(this.solrClient.getHttpClient(), url);
                    PackageUtils.printGreen(response);
                    String actualValue = null;
                    try {
                        actualValue = (String)JsonPath.parse((String)response, (Configuration)PackageUtils.jsonPathConfiguration()).read(PackageUtils.resolve(cmd.condition, pkg.parameterDefaults, overridesMap, systemParams), new Predicate[0]);
                    }
                    catch (PathNotFoundException ex) {
                        PackageUtils.printRed("Failed to deploy plugin: " + plugin.name);
                        success = false;
                    }
                    if (actualValue == null) continue;
                    String expectedValue = PackageUtils.resolve(cmd.expected, pkg.parameterDefaults, overridesMap, systemParams);
                    PackageUtils.printGreen("Actual: " + actualValue + ", expected: " + expectedValue);
                    if (expectedValue.equals(actualValue)) continue;
                    PackageUtils.printRed("Failed to deploy plugin: " + plugin.name);
                    success = false;
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-GET method not supported for verify commands");
            }
            for (String collection : collections) {
                Map<String, String> collectionParameterOverrides = this.getPackageParams(pkg.name, collection);
                Map<String, String> systemParams = Map.of("collection", collection, "package-name", pkg.name, "package-version", pkg.version, "plugin-name", plugin.name);
                String url = this.solrBaseUrl + PackageUtils.resolve(cmd.path, pkg.parameterDefaults, collectionParameterOverrides, systemParams);
                PackageUtils.printGreen("Executing " + url + " for collection:" + collection);
                if ("GET".equalsIgnoreCase(cmd.method)) {
                    String response = PackageUtils.getJsonStringFromUrl(this.solrClient.getHttpClient(), url);
                    PackageUtils.printGreen(response);
                    String actualValue = null;
                    try {
                        actualValue = (String)JsonPath.parse((String)response, (Configuration)PackageUtils.jsonPathConfiguration()).read(PackageUtils.resolve(cmd.condition, pkg.parameterDefaults, collectionParameterOverrides, systemParams), new Predicate[0]);
                    }
                    catch (PathNotFoundException ex) {
                        PackageUtils.printRed("Failed to deploy plugin: " + plugin.name);
                        success = false;
                    }
                    if (actualValue == null) continue;
                    String expectedValue = PackageUtils.resolve(cmd.expected, pkg.parameterDefaults, collectionParameterOverrides, systemParams);
                    PackageUtils.printGreen("Actual: " + actualValue + ", expected: " + expectedValue);
                    if (expectedValue.equals(actualValue)) continue;
                    PackageUtils.printRed("Failed to deploy plugin: " + plugin.name);
                    success = false;
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-GET method not supported for verify commands");
            }
        }
        return success;
    }

    public SolrPackageInstance getPackageInstance(String packageName, String version) {
        this.fetchInstalledPackageInstances();
        List<SolrPackageInstance> versions = this.packages.get(packageName);
        SolrPackageInstance latest = null;
        if (versions != null && !versions.isEmpty()) {
            latest = versions.get(0);
            for (int i = 0; i < versions.size(); ++i) {
                SolrPackageInstance pkg = versions.get(i);
                if (pkg.version.equals(version)) {
                    return pkg;
                }
                if (PackageUtils.compareVersions(latest.version, pkg.version) > 0) continue;
                latest = pkg;
            }
        }
        if (version == null || version.equalsIgnoreCase(PackageUtils.LATEST) || version.equalsIgnoreCase("$LATEST")) {
            return latest;
        }
        return null;
    }

    public void deploy(String packageName, String version, String[] collections, boolean shouldInstallClusterPlugins, String[] parameters, boolean isUpdate, boolean noprompt) throws SolrException {
        this.ensureCollectionsExist(Arrays.asList(collections));
        boolean pegToLatest = PackageUtils.LATEST.equals(version);
        SolrPackageInstance packageInstance = this.getPackageInstance(packageName, version);
        if (packageInstance == null) {
            PackageUtils.printRed("Package instance doesn't exist: " + packageName + ":" + version + ". Use install command to install this version first.");
            System.exit(1);
        }
        SolrPackage.Manifest manifest = packageInstance.manifest;
        try {
            if (!SolrVersion.LATEST.satisfies(manifest.versionConstraint)) {
                PackageUtils.printRed("Version incompatible! Solr version: " + SolrVersion.LATEST + ", package version constraint: " + manifest.versionConstraint);
                System.exit(1);
            }
        }
        catch (SolrVersion.InvalidSemVerExpressionException ex) {
            PackageUtils.printRed("Error in version constraint given in package manifest: " + manifest.versionConstraint + ". It does not a valid SemVer expression.");
            System.exit(1);
        }
        boolean res = this.deployPackage(packageInstance, pegToLatest, isUpdate, noprompt, Arrays.asList(collections), shouldInstallClusterPlugins, parameters);
        PackageUtils.print(res ? PackageUtils.GREEN : PackageUtils.RED, res ? "Deployment successful" : "Deployment failed");
    }

    public void undeploy(String packageName, String[] collections, boolean shouldUndeployClusterPlugins) throws SolrException {
        this.ensureCollectionsExist(Arrays.asList(collections));
        if (shouldUndeployClusterPlugins) {
            SolrPackageInstance deployedPackage = this.getPackagesDeployedAsClusterLevelPlugins().get(packageName);
            if (deployedPackage == null) {
                PackageUtils.printRed("Cluster level plugins from package " + packageName + " not deployed.");
            } else {
                for (SolrPackage.Plugin plugin : deployedPackage.plugins) {
                    if (!shouldUndeployClusterPlugins || !"cluster".equalsIgnoreCase(plugin.type)) continue;
                    Map<String, String> systemParams = Map.of("package-name", deployedPackage.name, "package-version", deployedPackage.version, "plugin-name", plugin.name);
                    SolrPackage.Command cmd = plugin.uninstallCommand;
                    if (cmd != null && !Strings.isNullOrEmpty((String)cmd.method)) {
                        if ("POST".equalsIgnoreCase(cmd.method)) {
                            try {
                                String payload = PackageUtils.resolve(PackageUtils.getMapper().writeValueAsString(cmd.payload), deployedPackage.parameterDefaults, Collections.emptyMap(), systemParams);
                                String path = PackageUtils.resolve(cmd.path, deployedPackage.parameterDefaults, Collections.emptyMap(), systemParams);
                                PackageUtils.printGreen("Executing " + payload + " for path:" + (String)path);
                                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, path, payload);
                                continue;
                            }
                            catch (Exception ex) {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
                            }
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-POST method not supported for uninstall commands");
                    }
                    PackageUtils.printRed("There is no uninstall command to execute for plugin: " + plugin.name);
                }
            }
        }
        for (String collection : collections) {
            SolrPackageInstance deployedPackage = this.getPackagesDeployed(collection).get(packageName);
            if (deployedPackage == null) {
                PackageUtils.printRed("Package " + packageName + " not deployed on collection " + collection);
                continue;
            }
            Map<String, String> collectionParameterOverrides = this.getPackageParams(packageName, collection);
            for (SolrPackage.Plugin plugin : deployedPackage.plugins) {
                if (!"collection".equalsIgnoreCase(plugin.type)) continue;
                Map<String, String> systemParams = Map.of("collection", collection, "package-name", deployedPackage.name, "package-version", deployedPackage.version, "plugin-name", plugin.name);
                SolrPackage.Command cmd = plugin.uninstallCommand;
                if (cmd != null && !Strings.isNullOrEmpty((String)cmd.method)) {
                    if ("POST".equalsIgnoreCase(cmd.method)) {
                        try {
                            String payload = PackageUtils.resolve(PackageUtils.getMapper().writeValueAsString(cmd.payload), deployedPackage.parameterDefaults, collectionParameterOverrides, systemParams);
                            String path = PackageUtils.resolve(cmd.path, deployedPackage.parameterDefaults, collectionParameterOverrides, systemParams);
                            PackageUtils.printGreen("Executing " + payload + " for path:" + path);
                            SolrCLI.postJsonToSolr((SolrClient)this.solrClient, path, payload);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
                        }
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Non-POST method not supported for uninstall commands");
                }
                PackageUtils.printRed("There is no uninstall command to execute for plugin: " + plugin.name);
            }
            try {
                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.getCollectionParamsPath(collection), "{set: {PKG_VERSIONS: {" + packageName + ": null}}}");
                SolrCLI.postJsonToSolr((SolrClient)this.solrClient, PackageUtils.PACKAGE_PATH, "{\"refresh\": \"" + packageName + "\"}");
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ex);
            }
        }
    }

    public Map<String, String> getDeployedCollections(String packageName) {
        List allCollections;
        try {
            allCollections = this.zkClient.getChildren("/collections", null, true);
        }
        catch (InterruptedException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, e);
        }
        HashMap<String, String> deployed = new HashMap<String, String>();
        for (String collection : allCollections) {
            String paramsJson = PackageUtils.getJsonStringFromUrl(this.solrClient.getHttpClient(), this.solrBaseUrl + PackageUtils.getCollectionParamsPath(collection) + "/PKG_VERSIONS?omitHeader=true");
            String version = null;
            try {
                version = (String)JsonPath.parse((String)paramsJson, (Configuration)PackageUtils.jsonPathConfiguration()).read("$['response'].['params'].['PKG_VERSIONS'].['" + packageName + "'])", new Predicate[0]);
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            if (version == null) continue;
            deployed.put(collection, version);
        }
        return deployed;
    }
}

