/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class ReplaceFunction {
    public static final String name = "replace";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 3) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The replace function requires 3 paramaters, " + params.length + " found.");
        }
        if (!(params[1] instanceof AnalyticsValue) || !(params[2] instanceof AnalyticsValue)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The replace function requires the comparator and fill parameters to be single-valued.");
        }
        AnalyticsValueStream baseExpr = params[0];
        AnalyticsValue compExpr = (AnalyticsValue)params[1];
        AnalyticsValue fillExpr = (AnalyticsValue)params[2];
        if (baseExpr instanceof DateValue && compExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateReplaceFunction((DateValue)baseExpr, (DateValue)compExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof DateValueStream && compExpr instanceof DateValue && fillExpr instanceof DateValue) {
            return new DateStreamReplaceFunction((DateValueStream)baseExpr, (DateValue)compExpr, (DateValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValue && compExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanReplaceFunction((BooleanValue)baseExpr, (BooleanValue)compExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof BooleanValueStream && compExpr instanceof BooleanValue && fillExpr instanceof BooleanValue) {
            return new BooleanStreamReplaceFunction((BooleanValueStream)baseExpr, (BooleanValue)compExpr, (BooleanValue)fillExpr);
        }
        if (baseExpr instanceof IntValue && compExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntReplaceFunction((IntValue)baseExpr, (IntValue)compExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof IntValueStream && compExpr instanceof IntValue && fillExpr instanceof IntValue) {
            return new IntStreamReplaceFunction((IntValueStream)baseExpr, (IntValue)compExpr, (IntValue)fillExpr);
        }
        if (baseExpr instanceof LongValue && compExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongReplaceFunction((LongValue)baseExpr, (LongValue)compExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof LongValueStream && compExpr instanceof LongValue && fillExpr instanceof LongValue) {
            return new LongStreamReplaceFunction((LongValueStream)baseExpr, (LongValue)compExpr, (LongValue)fillExpr);
        }
        if (baseExpr instanceof FloatValue && compExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatReplaceFunction((FloatValue)baseExpr, (FloatValue)compExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof FloatValueStream && compExpr instanceof FloatValue && fillExpr instanceof FloatValue) {
            return new FloatStreamReplaceFunction((FloatValueStream)baseExpr, (FloatValue)compExpr, (FloatValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValue && compExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleReplaceFunction((DoubleValue)baseExpr, (DoubleValue)compExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof DoubleValueStream && compExpr instanceof DoubleValue && fillExpr instanceof DoubleValue) {
            return new DoubleStreamReplaceFunction((DoubleValueStream)baseExpr, (DoubleValue)compExpr, (DoubleValue)fillExpr);
        }
        if (baseExpr instanceof StringValue && compExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringReplaceFunction((StringValue)baseExpr, (StringValue)compExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof StringValueStream && compExpr instanceof StringValue && fillExpr instanceof StringValue) {
            return new StringStreamReplaceFunction((StringValueStream)baseExpr, (StringValue)compExpr, (StringValue)fillExpr);
        }
        if (baseExpr instanceof AnalyticsValue) {
            return new ValueReplaceFunction((AnalyticsValue)baseExpr, compExpr, fillExpr);
        }
        return new StreamReplaceFunction(baseExpr, compExpr, fillExpr);
    };

    static class StringReplaceFunction
    extends StringValue.AbstractStringValue {
        private final StringValue baseExpr;
        private final StringValue compExpr;
        private final StringValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public StringReplaceFunction(StringValue baseExpr, StringValue compExpr, StringValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public String getString() {
            String value = this.baseExpr.getString();
            this.exists = this.baseExpr.exists();
            String comp = this.compExpr.getString();
            if (this.exists && this.compExpr.exists() && value.equals(comp)) {
                value = this.fillExpr.getString();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringStreamReplaceFunction
    extends StringValueStream.AbstractStringValueStream {
        private final StringValueStream baseExpr;
        private final StringValue compExpr;
        private final StringValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamReplaceFunction(StringValueStream baseExpr, StringValue compExpr, StringValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamStrings(Consumer<String> cons) {
            String compValue = this.compExpr.getString();
            if (this.compExpr.exists()) {
                String fillValue = this.fillExpr.getString();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamStrings(value -> {
                    if (value.equals(compValue)) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept((String)value);
                    }
                });
            } else {
                this.baseExpr.streamStrings(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateReplaceFunction
    extends DateValue.AbstractDateValue {
        private final DateValue baseExpr;
        private final DateValue compExpr;
        private final DateValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DateReplaceFunction(DateValue baseExpr, DateValue compExpr, DateValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = this.baseExpr.exists();
            long comp = this.compExpr.getLong();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getLong();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DateStreamReplaceFunction
    extends DateValueStream.AbstractDateValueStream {
        private final DateValueStream baseExpr;
        private final DateValue compExpr;
        private final DateValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DateStreamReplaceFunction(DateValueStream baseExpr, DateValue compExpr, DateValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long compValue = this.compExpr.getLong();
            if (this.compExpr.exists()) {
                long fillValue = this.fillExpr.getLong();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamLongs(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleReplaceFunction
    extends DoubleValue.AbstractDoubleValue {
        private final DoubleValue baseExpr;
        private final DoubleValue compExpr;
        private final DoubleValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public DoubleReplaceFunction(DoubleValue baseExpr, DoubleValue compExpr, DoubleValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public double getDouble() {
            double value = this.baseExpr.getDouble();
            this.exists = this.baseExpr.exists();
            double comp = this.compExpr.getDouble();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getDouble();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class DoubleStreamReplaceFunction
    extends DoubleValueStream.AbstractDoubleValueStream {
        private final DoubleValueStream baseExpr;
        private final DoubleValue compExpr;
        private final DoubleValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public DoubleStreamReplaceFunction(DoubleValueStream baseExpr, DoubleValue compExpr, DoubleValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamDoubles(DoubleConsumer cons) {
            double compValue = this.compExpr.getDouble();
            if (this.compExpr.exists()) {
                double fillValue = this.fillExpr.getDouble();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamDoubles(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamDoubles(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatReplaceFunction
    extends FloatValue.AbstractFloatValue {
        private final FloatValue baseExpr;
        private final FloatValue compExpr;
        private final FloatValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public FloatReplaceFunction(FloatValue baseExpr, FloatValue compExpr, FloatValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public float getFloat() {
            float value = this.baseExpr.getFloat();
            this.exists = this.baseExpr.exists();
            float comp = this.compExpr.getFloat();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getFloat();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class FloatStreamReplaceFunction
    extends FloatValueStream.AbstractFloatValueStream {
        private final FloatValueStream baseExpr;
        private final FloatValue compExpr;
        private final FloatValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public FloatStreamReplaceFunction(FloatValueStream baseExpr, FloatValue compExpr, FloatValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamFloats(FloatConsumer cons) {
            float compValue = this.compExpr.getFloat();
            if (this.compExpr.exists()) {
                float fillValue = this.fillExpr.getFloat();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamFloats(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamFloats(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongReplaceFunction
    extends LongValue.AbstractLongValue {
        private final LongValue baseExpr;
        private final LongValue compExpr;
        private final LongValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public LongReplaceFunction(LongValue baseExpr, LongValue compExpr, LongValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public long getLong() {
            long value = this.baseExpr.getLong();
            this.exists = this.baseExpr.exists();
            long comp = this.compExpr.getLong();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getLong();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamReplaceFunction
    extends LongValueStream.AbstractLongValueStream {
        private final LongValueStream baseExpr;
        private final LongValue compExpr;
        private final LongValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamReplaceFunction(LongValueStream baseExpr, LongValue compExpr, LongValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            long compValue = this.compExpr.getLong();
            if (this.compExpr.exists()) {
                long fillValue = this.fillExpr.getLong();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamLongs(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamLongs(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntReplaceFunction
    extends IntValue.AbstractIntValue {
        private final IntValue baseExpr;
        private final IntValue compExpr;
        private final IntValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public IntReplaceFunction(IntValue baseExpr, IntValue compExpr, IntValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public int getInt() {
            int value = this.baseExpr.getInt();
            this.exists = this.baseExpr.exists();
            int comp = this.compExpr.getInt();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getInt();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class IntStreamReplaceFunction
    extends IntValueStream.AbstractIntValueStream {
        private final IntValueStream baseExpr;
        private final IntValue compExpr;
        private final IntValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public IntStreamReplaceFunction(IntValueStream baseExpr, IntValue compExpr, IntValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamInts(IntConsumer cons) {
            int compValue = this.compExpr.getInt();
            if (this.compExpr.exists()) {
                int fillValue = this.fillExpr.getInt();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamInts(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamInts(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanReplaceFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue baseExpr;
        private final BooleanValue compExpr;
        private final BooleanValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public BooleanReplaceFunction(BooleanValue baseExpr, BooleanValue compExpr, BooleanValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public boolean getBoolean() {
            boolean value = this.baseExpr.getBoolean();
            this.exists = this.baseExpr.exists();
            boolean comp = this.compExpr.getBoolean();
            if (this.exists && this.compExpr.exists() && value == comp) {
                value = this.fillExpr.getBoolean();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamReplaceFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValueStream baseExpr;
        private final BooleanValue compExpr;
        private final BooleanValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamReplaceFunction(BooleanValueStream baseExpr, BooleanValue compExpr, BooleanValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean compValue = this.compExpr.getBoolean();
            if (this.compExpr.exists()) {
                boolean fillValue = this.fillExpr.getBoolean();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamBooleans(value -> {
                    if (value == compValue) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamBooleans(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueReplaceFunction
    extends AnalyticsValue.AbstractAnalyticsValue {
        private final AnalyticsValue baseExpr;
        private final AnalyticsValue compExpr;
        private final AnalyticsValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        boolean exists = false;

        public ValueReplaceFunction(AnalyticsValue baseExpr, AnalyticsValue compExpr, AnalyticsValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public Object getObject() {
            Object value = this.baseExpr.getObject();
            this.exists = this.baseExpr.exists();
            Object comp = this.compExpr.getObject();
            if (this.exists && this.compExpr.exists() && value.equals(comp)) {
                value = this.fillExpr.getObject();
                this.exists = this.fillExpr.exists();
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StreamReplaceFunction
    extends AnalyticsValueStream.AbstractAnalyticsValueStream {
        private final AnalyticsValueStream baseExpr;
        private final AnalyticsValue compExpr;
        private final AnalyticsValue fillExpr;
        public static final String name = "replace";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StreamReplaceFunction(AnalyticsValueStream baseExpr, AnalyticsValue compExpr, AnalyticsValue fillExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.fillExpr = fillExpr;
            this.exprStr = AnalyticsValueStream.createExpressionString("replace", baseExpr, compExpr, fillExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, compExpr, fillExpr);
        }

        @Override
        public void streamObjects(Consumer<Object> cons) {
            Object compValue = this.compExpr.getObject();
            if (this.compExpr.exists()) {
                Object fillValue = this.fillExpr.getObject();
                boolean fillExists = this.fillExpr.exists();
                this.baseExpr.streamObjects(value -> {
                    if (value.equals(compValue)) {
                        if (fillExists) {
                            cons.accept(fillValue);
                        }
                    } else {
                        cons.accept(value);
                    }
                });
            } else {
                this.baseExpr.streamObjects(cons);
            }
        }

        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

