/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;

public class ClearBuffersAction
extends MessageAction {
    public ClearBuffersAction() {
    }

    public ClearBuffersAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        tlsContext.getMessageBuffer().clear();
        tlsContext.getRecordBuffer().clear();
        this.setExecuted(true);
    }

    public String toString() {
        return "ClearBuffersAction";
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void reset() {
        this.setExecuted(null);
    }
}

