/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0017\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0018\u001a\u00020\u0011*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J$\u0010\u001d\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001e\u001a\u00020\u001c*\u00020\u0015H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkAsTopLevelTypeReference", "topLevelTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isReceiver", "", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "checkIfMutableProperty", "checkIfProperty", "diagnosticFactory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "", "checkTypeReference", "useSiteDescription", "frontend"})
@SourceDebugExtension(value={"SMAP\nAnnotationUseSiteTargetChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationUseSiteTargetChecker.kt\norg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class AnnotationUseSiteTargetChecker {
    @NotNull
    public static final AnnotationUseSiteTargetChecker INSTANCE = new AnnotationUseSiteTargetChecker();

    private AnnotationUseSiteTargetChecker() {
    }

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        this.checkDeclaration(trace, annotated, languageVersionSettings2, descriptor2);
        if (annotated instanceof KtCallableDeclaration) {
            KtTypeReference it;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)annotated).getReceiverTypeReference();
            if (ktTypeReference != null) {
                it = ktTypeReference;
                boolean bl = false;
                INSTANCE.checkTypeReference(trace, it, languageVersionSettings2, true);
            }
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)annotated).getTypeReference();
            if (ktTypeReference2 != null) {
                it = ktTypeReference2;
                boolean bl = false;
                INSTANCE.checkTypeReference(trace, it, languageVersionSettings2, false);
            }
        }
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter2 : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter2.hasValOrVar() || (VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter2) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter");
                this.checkDeclaration(trace, parameter2, languageVersionSettings2, parameterDescriptor);
                if (parameter2.getTypeReference() != null) {
                    KtTypeReference it;
                    boolean bl = false;
                    INSTANCE.checkTypeReference(trace, it, languageVersionSettings2, false);
                }
            }
        }
    }

    private final void checkTypeReference(BindingTrace $this$checkTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings2, boolean isReceiver) {
        this.checkAsTopLevelTypeReference($this$checkTypeReference, topLevelTypeReference, languageVersionSettings2, isReceiver);
        topLevelTypeReference.acceptChildren(VisitorWrappersKt.typeReferenceRecursiveVisitor((Function1<? super KtTypeReference, Unit>)((Function1)new Function1<KtTypeReference, Unit>($this$checkTypeReference, languageVersionSettings2){
            final /* synthetic */ BindingTrace $this_checkTypeReference;
            final /* synthetic */ LanguageVersionSettings $languageVersionSettings;
            {
                this.$this_checkTypeReference = $receiver;
                this.$languageVersionSettings = $languageVersionSettings;
                super(1);
            }

            public final void invoke(@NotNull KtTypeReference typeReference) {
                Intrinsics.checkNotNullParameter((Object)typeReference, (String)"typeReference");
                AnnotationUseSiteTargetChecker.access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker.INSTANCE, this.$this_checkTypeReference, typeReference, this.$languageVersionSettings, false);
            }
        })));
    }

    private final void checkAsTopLevelTypeReference(BindingTrace $this$checkAsTopLevelTypeReference, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings2, boolean isReceiver) {
        for (KtAnnotationEntry annotationEntry : topLevelTypeReference.getAnnotationEntries()) {
            ParametrizedDiagnostic<KtAnnotationEntry> diagnostic;
            Object target;
            Object object = annotationEntry.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (target = object) == AnnotationUseSiteTarget.RECEIVER && isReceiver) continue;
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings2.supportsFeature(LanguageFeature.RestrictionOfWrongAnnotationsWithUseSiteTargetsOnTypes) ? Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry), "undefined target", ((AnnotationUseSiteTarget)((Object)target)).getRenderName()) : Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET_ON_TYPE.on((KtAnnotationEntry)((PsiElement)annotationEntry), ((AnnotationUseSiteTarget)((Object)target)).getRenderName()), (String)"if (languageVersionSetti\u2026Entry, target.renderName)");
            diagnostic = diagnostic;
            DiagnosticUtilsKt.reportDiagnosticOnce($this$checkAsTopLevelTypeReference, diagnostic);
        }
    }

    private final void checkDeclaration(BindingTrace $this$checkDeclaration, KtAnnotated annotated, LanguageVersionSettings languageVersionSettings2, DeclarationDescriptor descriptor2) {
        for (KtAnnotationEntry annotation2 : annotated.getAnnotationEntries()) {
            KtAnnotationUseSiteTarget useSiteTarget = annotation2.getUseSiteTarget();
            Object object = useSiteTarget;
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) continue;
            Object target = object;
            switch (WhenMappings.$EnumSwitchMapping$0[((Enum)target).ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                    this.checkIfHasBackingField($this$checkDeclaration, annotated, descriptor2, annotation2);
                    break;
                }
                case 2: 
                case 3: {
                    DiagnosticFactory1<PsiElement, String> diagnosticFactory1;
                    Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                    boolean bl = languageVersionSettings2.supportsFeature(LanguageFeature.ProhibitUseSiteGetTargetAnnotations);
                    if (bl) {
                        diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY;
                    } else if (!bl) {
                        diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY_WARNING;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"when (languageVersionSet\u2026ING\n                    }");
                    this.checkIfProperty($this$checkDeclaration, annotated, annotation2, diagnosticFactory1);
                    break;
                }
                case 4: {
                    Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                    this.checkIfDelegatedProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 5: {
                    Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$this$checkDeclaration.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $this$checkDeclaration.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) break;
                    $this$checkDeclaration.report(Errors.REDUNDANT_ANNOTATION_TARGET.on(annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue((Object)annotation2, (String)"annotation");
                    this.checkIfMutableProperty($this$checkDeclaration, annotated, annotation2);
                    break;
                }
                case 8: {
                    SimpleDiagnostic<KtAnnotationUseSiteTarget> simpleDiagnostic = Errors.INAPPLICABLE_FILE_TARGET.on((KtAnnotationUseSiteTarget)((PsiElement)useSiteTarget));
                    Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"INAPPLICABLE_FILE_TARGET.on(useSiteTarget)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, simpleDiagnostic);
                    break;
                }
                case 9: {
                    ParametrizedDiagnostic<KtAnnotationEntry> parametrizedDiagnostic = Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET.on((KtAnnotationEntry)((PsiElement)annotation2), "declaration", ((AnnotationUseSiteTarget)((Object)target)).getRenderName());
                    Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, (String)"WRONG_ANNOTATION_TARGET_\u2026tion\", target.renderName)");
                    DiagnosticUtilsKt.reportDiagnosticOnce($this$checkDeclaration, parametrizedDiagnostic);
                }
            }
        }
    }

    private final void checkIfDelegatedProperty(BindingTrace $this$checkIfDelegatedProperty, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $this$checkIfDelegatedProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on(annotation2));
        }
    }

    private final void checkIfHasBackingField(BindingTrace $this$checkIfHasBackingField, KtAnnotated annotated, DeclarationDescriptor descriptor2, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor2 instanceof PropertyDescriptor && !Intrinsics.areEqual($this$checkIfHasBackingField.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2), (Object)true)) {
            $this$checkIfHasBackingField.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on(annotation2));
        }
    }

    private final String useSiteDescription(KtAnnotationEntry $this$useSiteDescription) {
        Object object = $this$useSiteDescription.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(BindingTrace $this$checkIfMutableProperty, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.INAPPLICABLE_TARGET_ON_PROPERTY;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, (String)"INAPPLICABLE_TARGET_ON_PROPERTY");
        if (!this.checkIfProperty($this$checkIfMutableProperty, annotated, annotation2, diagnosticFactory1)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $this$checkIfMutableProperty.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on(annotation2, this.useSiteDescription(annotation2)));
        }
    }

    private final boolean checkIfProperty(BindingTrace $this$checkIfProperty, KtAnnotated annotated, KtAnnotationEntry annotation2, DiagnosticFactory1<PsiElement, String> diagnosticFactory) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $this$checkIfProperty.report(diagnosticFactory.on(annotation2, this.useSiteDescription(annotation2)));
        }
        return isProperty;
    }

    public static final /* synthetic */ void access$checkAsTopLevelTypeReference(AnnotationUseSiteTargetChecker $this, BindingTrace $receiver, KtTypeReference topLevelTypeReference, LanguageVersionSettings languageVersionSettings2, boolean isReceiver) {
        $this.checkAsTopLevelTypeReference($receiver, topLevelTypeReference, languageVersionSettings2, isReceiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.FILE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.RECEIVER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

