/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

public final class WrapperSystemPropertyUtil {
    public static String getStringProperty(String name, String defaultValue) {
        String val = System.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = WrapperSystemPropertyUtil.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        return val.equalsIgnoreCase("TRUE");
    }

    public static int getIntProperty(String name, int defaultValue) {
        String val = WrapperSystemPropertyUtil.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLongProperty(String name, long defaultValue) {
        String val = WrapperSystemPropertyUtil.getStringProperty(name, null);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private WrapperSystemPropertyUtil() {
    }
}

