/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import sun.jvm.hotspot.utilities.AltPlatformInfo;
import sun.jvm.hotspot.utilities.UnsupportedPlatformException;

public class PlatformInfo {
    public static String getOS() throws UnsupportedPlatformException {
        String os = System.getProperty("os.name");
        if (os.equals("SunOS")) {
            return "solaris";
        }
        if (os.equals("Linux")) {
            return "linux";
        }
        if (os.equals("FreeBSD")) {
            return "bsd";
        }
        if (os.equals("NetBSD")) {
            return "bsd";
        }
        if (os.equals("OpenBSD")) {
            return "bsd";
        }
        if (os.contains("Darwin") || os.contains("OS X")) {
            return "darwin";
        }
        if (os.startsWith("Windows")) {
            return "win32";
        }
        throw new UnsupportedPlatformException("Operating system " + os + " not yet supported");
    }

    public static String getCPU() throws UnsupportedPlatformException {
        String cpu = System.getProperty("os.arch");
        if (cpu.equals("i386") || cpu.equals("x86")) {
            return "x86";
        }
        if (cpu.equals("sparc") || cpu.equals("sparcv9")) {
            return "sparc";
        }
        if (cpu.equals("ia64") || cpu.equals("amd64") || cpu.equals("x86_64") || cpu.equals("ppc64")) {
            return cpu;
        }
        if (cpu.equals("aarch64")) {
            return cpu;
        }
        try {
            Class<?> pic = Class.forName("sun.jvm.hotspot.utilities.PlatformInfoClosed");
            AltPlatformInfo api = (AltPlatformInfo)pic.newInstance();
            if (api.knownCPU(cpu)) {
                return cpu;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedPlatformException("CPU type " + cpu + " not yet supported");
    }

    public static void main(String[] args) {
        System.out.println(PlatformInfo.getOS());
    }
}

