/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.StringJoiner;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.handlers.EventHandler;

final class EventHandlerProxyCreator {
    private static final int CLASS_VERSION = 52;
    private static final Type TYPE_EVENT_TYPE = Type.getType(EventType.class);
    private static final Type TYPE_EVENT_CONTROL = Type.getType(EventControl.class);
    private static final String DESCRIPTOR_EVENT_HANDLER = "(" + Type.BOOLEAN_TYPE.getDescriptor() + TYPE_EVENT_TYPE.getDescriptor() + TYPE_EVENT_CONTROL.getDescriptor() + ")V";
    private static final Method METHOD_EVENT_HANDLER_CONSTRUCTOR = new Method("<init>", DESCRIPTOR_EVENT_HANDLER);
    private static final String DESCRIPTOR_TIME_STAMP = "()" + Type.LONG_TYPE.getDescriptor();
    private static final Method METHOD_TIME_STAMP = new Method("timestamp", DESCRIPTOR_TIME_STAMP);
    private static final String DESCRIPTOR_DURATION = "(" + Type.LONG_TYPE.getDescriptor() + ")" + Type.LONG_TYPE.getDescriptor();
    private static final Method METHOD_DURATION = new Method("duration", DESCRIPTOR_DURATION);
    private static final ClassWriter classWriter = new ClassWriter(3);
    private static final String className = "jdk.jfr.proxy.internal.EventHandlerProxy";
    private static final String internalClassName = ASMToolkit.getInternalName("jdk.jfr.proxy.internal.EventHandlerProxy");
    static final Class<? extends EventHandler> proxyClass = EventHandlerProxyCreator.makeEventHandlerProxyClass();

    EventHandlerProxyCreator() {
    }

    static void ensureInitialized() {
    }

    public static Class<? extends EventHandler> makeEventHandlerProxyClass() {
        EventHandlerProxyCreator.buildClassInfo();
        EventHandlerProxyCreator.buildConstructor();
        EventHandlerProxyCreator.buildTimestampMethod();
        EventHandlerProxyCreator.buildDurationMethod();
        byte[] byArray = classWriter.toByteArray();
        ASMToolkit.logASM(className, byArray);
        return SecuritySupport.defineClass(className, byArray, Event.class.getClassLoader()).asSubclass(EventHandler.class);
    }

    private static void buildConstructor() {
        MethodVisitor methodVisitor = classWriter.visitMethod(0, METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), EventHandlerProxyCreator.makeConstructorDescriptor(), null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(21, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(EventHandler.class), METHOD_EVENT_HANDLER_CONSTRUCTOR.getName(), METHOD_EVENT_HANDLER_CONSTRUCTOR.getDescriptor(), false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void buildClassInfo() {
        String string = ASMToolkit.getInternalName(EventHandler.class.getName());
        classWriter.visit(52, 1057, internalClassName, null, string, null);
    }

    private static void buildTimestampMethod() {
        MethodVisitor methodVisitor = classWriter.visitMethod(9, METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitMethodInsn(184, Type.getInternalName(EventHandler.class), METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), false);
        methodVisitor.visitInsn(173);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static void buildDurationMethod() {
        MethodVisitor methodVisitor = classWriter.visitMethod(9, METHOD_DURATION.getName(), METHOD_DURATION.getDescriptor(), null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(22, 0);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(EventHandler.class), METHOD_DURATION.getName(), METHOD_DURATION.getDescriptor(), false);
        methodVisitor.visitInsn(173);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static String makeConstructorDescriptor() {
        StringJoiner stringJoiner = new StringJoiner("", "(", ")V");
        stringJoiner.add(Type.BOOLEAN_TYPE.getDescriptor());
        stringJoiner.add(Type.getType(EventType.class).getDescriptor());
        stringJoiner.add(Type.getType(EventControl.class).getDescriptor());
        return stringJoiner.toString();
    }
}

