# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("resutils.dll")
prototypes = \
    {
        #
        'InitializeClusterHealthFault': SimTypeFunction([SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["clusterHealthFault"]),
        #
        'InitializeClusterHealthFaultArray': SimTypeFunction([SimTypePointer(SimStruct({"numFaults": SimTypeInt(signed=False, label="UInt32"), "faults": SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0)}, name="CLUSTER_HEALTH_FAULT_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["clusterHealthFaultArray"]),
        #
        'FreeClusterHealthFault': SimTypeFunction([SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["clusterHealthFault"]),
        #
        'FreeClusterHealthFaultArray': SimTypeFunction([SimTypePointer(SimStruct({"numFaults": SimTypeInt(signed=False, label="UInt32"), "faults": SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0)}, name="CLUSTER_HEALTH_FAULT_ARRAY", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["clusterHealthFaultArray"]),
        #
        'ClusGetClusterHealthFaults': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"numFaults": SimTypeInt(signed=False, label="UInt32"), "faults": SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0)}, name="CLUSTER_HEALTH_FAULT_ARRAY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "objects", "flags"]),
        #
        'ClusRemoveClusterHealthFault': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "id", "flags"]),
        #
        'ClusAddClusterHealthFault': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Id": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ErrorType": SimTypeInt(signed=False, label="UInt32"), "ErrorCode": SimTypeInt(signed=False, label="UInt32"), "Description": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Provider": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Flags": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="CLUSTER_HEALTH_FAULT", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "failure", "param2"]),
        #
        'ResUtilStartResourceService': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName", "phServiceHandle"]),
        #
        'ResUtilVerifyResourceService': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName"]),
        #
        'ResUtilStopResourceService': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName"]),
        #
        'ResUtilVerifyService': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hServiceHandle"]),
        #
        'ResUtilStopService': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hServiceHandle"]),
        #
        'ResUtilCreateDirectoryTree': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszPath"]),
        #
        'ResUtilIsPathValid': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath"]),
        #
        'ResUtilEnumProperties': SimTypeFunction([SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyTable", "pszOutProperties", "cbOutPropertiesSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilEnumPrivateProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszOutProperties", "cbOutPropertiesSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilGetProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "pOutPropertyList", "cbOutPropertyListSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilGetAllProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "pOutPropertyList", "cbOutPropertyListSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilGetPrivateProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pOutPropertyList", "cbOutPropertyListSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilGetPropertySize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTableItem", "pcbOutPropertyListSize", "pnPropertyCount"]),
        #
        'ResUtilGetProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTableItem", "pOutPropertyItem", "pcbOutPropertyItemSize"]),
        #
        'ResUtilVerifyPropertyTable': SimTypeFunction([SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyTable", "Reserved", "bAllowUnknownProperties", "pInPropertyList", "cbInPropertyListSize", "pOutParams"]),
        #
        'ResUtilSetPropertyTable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "Reserved", "bAllowUnknownProperties", "pInPropertyList", "cbInPropertyListSize", "pOutParams"]),
        #
        'ResUtilSetPropertyTableEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "Reserved", "bAllowUnknownProperties", "pInPropertyList", "cbInPropertyListSize", "bForceWrite", "pOutParams"]),
        #
        'ResUtilSetPropertyParameterBlock': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "Reserved", "pInParams", "pInPropertyList", "cbInPropertyListSize", "pOutParams"]),
        #
        'ResUtilSetPropertyParameterBlockEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "Reserved", "pInParams", "pInPropertyList", "cbInPropertyListSize", "bForceWrite", "pOutParams"]),
        #
        'ResUtilSetUnknownProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "pInPropertyList", "cbInPropertyListSize"]),
        #
        'ResUtilGetPropertiesToParameterBlock': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "pOutParams", "bCheckForRequiredProperties", "pszNameOfPropInError"]),
        #
        'ResUtilPropertyListFromParameterBlock': SimTypeFunction([SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyTable", "pOutPropertyList", "pcbOutPropertyListSize", "pInParams", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilDupParameterBlock': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pOutParams", "pInParams", "pPropertyTable"]),
        #
        'ResUtilFreeParameterBlock': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pOutParams", "pInParams", "pPropertyTable"]),
        #
        'ResUtilAddUnknownProperties': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pPropertyTable", "pOutPropertyList", "pcbOutPropertyListSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilSetPrivatePropertyList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pInPropertyList", "cbInPropertyListSize"]),
        #
        'ResUtilVerifyPrivatePropertyList': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pInPropertyList", "cbInPropertyListSize"]),
        #
        'ResUtilDupString': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["pszInString"]),
        #
        'ResUtilGetBinaryValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "ppbOutValue", "pcbOutValueSize"]),
        #
        'ResUtilGetSzValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hkeyClusterKey", "pszValueName"]),
        #
        'ResUtilGetDwordValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pdwOutValue", "dwDefaultValue"]),
        #
        'ResUtilGetQwordValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pqwOutValue", "qwDefaultValue"]),
        #
        'ResUtilSetBinaryValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pbNewValue", "cbNewValueSize", "ppbOutValue", "pcbOutValueSize"]),
        #
        'ResUtilSetSzValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pszNewValue", "ppszOutString"]),
        #
        'ResUtilSetExpandSzValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pszNewValue", "ppszOutString"]),
        #
        'ResUtilSetMultiSzValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "pszNewValue", "cbNewValueSize", "ppszOutValue", "pcbOutValueSize"]),
        #
        'ResUtilSetDwordValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "dwNewValue", "pdwOutValue"]),
        #
        'ResUtilSetQwordValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "pszValueName", "qwNewValue", "pqwOutValue"]),
        #
        'ResUtilSetValueEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hkeyClusterKey", "valueName", "valueType", "valueData", "valueSize", "flags"]),
        #
        'ResUtilGetBinaryProperty': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5092_C41": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "rgb": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CLUSPROP_BINARY", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppbOutValue", "pcbOutValueSize", "pValueStruct", "pbOldValue", "cbOldValueSize", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetSzProperty': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5132_C37": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "sz": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CLUSPROP_SZ", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppszOutValue", "pValueStruct", "pszOldValue", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetMultiSzProperty': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5132_C37": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "sz": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CLUSPROP_SZ", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ppszOutValue", "pcbOutValueSize", "pValueStruct", "pszOldValue", "cbOldValueSize", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetDwordProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5112_C40": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "dw": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_DWORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pdwOutValue", "pValueStruct", "dwOldValue", "dwMinimum", "dwMaximum", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetLongProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5122_C39": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "l": SimTypeInt(signed=True, label="Int32")}, name="CLUSPROP_LONG", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["plOutValue", "pValueStruct", "lOldValue", "lMinimum", "lMaximum", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetFileTimeProperty': SimTypeFunction([SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_clusapi_L5188_C14": SimStruct({"Syntax": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"wFormat": SimTypeShort(signed=False, label="UInt16"), "wType": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "cbLength": SimTypeInt(signed=False, label="UInt32")}, name="CLUSPROP_VALUE", pack=False, align=None), "ft": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="CLUSPROP_FILETIME", pack=False, align=None), offset=0), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pftOutValue", "pValueStruct", "ftOldValue", "ftMinimum", "ftMaximum", "ppPropertyList", "pcbPropertyListSize"]),
        #
        'ResUtilGetEnvironmentWithNetName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hResource"]),
        #
        'ResUtilFreeEnvironment': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpEnvironment"]),
        #
        'ResUtilExpandEnvironmentStrings': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["pszSrc"]),
        #
        'ResUtilSetResourceServiceEnvironment': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName", "hResource", "pfnLogEvent", "hResourceHandle"]),
        #
        'ResUtilRemoveResourceServiceEnvironment': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName", "pfnLogEvent", "hResourceHandle"]),
        #
        'ResUtilSetResourceServiceStartParameters': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName", "schSCMHandle", "phService", "pfnLogEvent", "hResourceHandle"]),
        #
        'ResUtilFindSzProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pszPropertyValue"]),
        #
        'ResUtilFindExpandSzProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pszPropertyValue"]),
        #
        'ResUtilFindExpandedSzProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pszPropertyValue"]),
        #
        'ResUtilFindDwordProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pdwPropertyValue"]),
        #
        'ResUtilFindBinaryProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pbPropertyValue", "pcbPropertyValueSize"]),
        #
        'ResUtilFindMultiSzProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pszPropertyValue", "pcbPropertyValueSize"]),
        #
        'ResUtilFindLongProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "plPropertyValue"]),
        #
        'ResUtilFindULargeIntegerProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "plPropertyValue"]),
        #
        'ResUtilFindFileTimeProperty': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyList", "cbPropertyListSize", "pszPropertyName", "pftPropertyValue"]),
        #
        'ClusWorkerCreate': SimTypeFunction([SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pWorker", "lpThreadParameter"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpWorker", "lpStartAddress", "lpParameter"]),
        #
        'ClusWorkerCheckTerminate': SimTypeFunction([SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpWorker"]),
        #
        'ClusWorkerTerminate': SimTypeFunction([SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["lpWorker"]),
        #
        'ClusWorkerTerminateEx': SimTypeFunction([SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ClusWorker", "TimeoutInMilliseconds", "WaitOnly"]),
        #
        'ClusWorkersTerminate': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"hThread": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Terminate": SimTypeInt(signed=True, label="Int32")}, name="CLUS_WORKER", pack=False, align=None), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ClusWorkers", "ClusWorkersCount", "TimeoutInMilliseconds", "WaitOnly"]),
        #
        'ResUtilResourcesEqual': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hSelf", "hResource"]),
        #
        'ResUtilResourceTypesEqual': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszResourceTypeName", "hResource"]),
        #
        'ResUtilIsResourceClassEqual': SimTypeFunction([SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"Anonymous": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "rc": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS")}, name="<anon>", label="None"), "SubClass": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "li": SimTypeBottom(label="ULARGE_INTEGER")}, name="<anon>", label="None")}, name="CLUS_RESOURCE_CLASS_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["prci", "hResource"]),
        #
        'ResUtilEnumResources': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hSelf", "lpszResTypeName", "pResCallBack", "pParameter"]),
        #
        'ResUtilEnumResourcesEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hSelf", "lpszResTypeName", "pResCallBack", "pParameter"]),
        #
        'ResUtilGetResourceDependency': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hSelf", "lpszResourceType"]),
        #
        'ResUtilGetResourceDependencyByName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "hSelf", "lpszResourceType", "bRecurse"]),
        #
        'ResUtilGetResourceDependencyByClass': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"Anonymous": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "rc": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS")}, name="<anon>", label="None"), "SubClass": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "li": SimTypeBottom(label="ULARGE_INTEGER")}, name="<anon>", label="None")}, name="CLUS_RESOURCE_CLASS_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "hSelf", "prci", "bRecurse"]),
        #
        'ResUtilGetResourceNameDependency': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["lpszResourceName", "lpszResourceType"]),
        #
        'ResUtilGetResourceDependentIPAddressProps': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "pszAddress", "pcchAddress", "pszSubnetMask", "pcchSubnetMask", "pszNetwork", "pcchNetwork"]),
        #
        'ResUtilFindDependentDiskResourceDriveLetter': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hResource", "pszDriveLetter", "pcchDriveLetter"]),
        #
        'ResUtilTerminateServiceProcessFromResDll': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwServicePid", "bOffline", "pdwResourceState", "pfnLogEvent", "hResourceHandle"]),
        #
        'ResUtilGetPropertyFormats': SimTypeFunction([SimTypePointer(SimStruct({"Name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "KeyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Format": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"DefaultPtr": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Default": SimTypeInt(signed=False, label="UInt32"), "lpDefault": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "LargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="LARGE_INTEGER"), "Minimum": SimTypeBottom(label="LARGE_INTEGER"), "Maximum": SimTypeBottom(label="LARGE_INTEGER")}, name="RESUTIL_LARGEINT_DATA", pack=False, align=None), offset=0), "ULargeIntData": SimTypePointer(SimStruct({"Default": SimTypeBottom(label="ULARGE_INTEGER"), "Minimum": SimTypeBottom(label="ULARGE_INTEGER"), "Maximum": SimTypeBottom(label="ULARGE_INTEGER")}, name="RESUTIL_ULARGEINT_DATA", pack=False, align=None), offset=0), "FileTimeData": SimTypePointer(SimStruct({"Default": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Minimum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Maximum": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="RESUTIL_FILETIME_DATA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "Minimum": SimTypeInt(signed=False, label="UInt32"), "Maximum": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="RESUTIL_PROPERTY_ITEM", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pPropertyTable", "pOutPropertyFormatList", "cbPropertyFormatListSize", "pcbBytesReturned", "pcbRequired"]),
        #
        'ResUtilGetCoreClusterResources': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "phClusterNameResource", "phClusterIPAddressResource", "phClusterQuorumResource"]),
        #
        'ResUtilGetResourceName': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hResource", "pszResourceName", "pcchResourceNameInOut"]),
        #
        'ResUtilGetClusterRoleState': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLUSTER_ROLE")], SimTypeInt(signed=False, label="CLUSTER_ROLE_STATE"), arg_names=["hCluster", "eClusterRole"]),
        #
        'ClusterIsPathOnSharedVolume': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszPathName"]),
        #
        'ClusterGetVolumePathName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszFileName", "lpszVolumePathName", "cchBufferLength"]),
        #
        'ClusterGetVolumeNameForVolumeMountPoint': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszVolumeMountPoint", "lpszVolumeName", "cchBufferLength"]),
        #
        'ClusterPrepareSharedVolumeForBackup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszFileName", "lpszVolumePathName", "lpcchVolumePathName", "lpszVolumeName", "lpcchVolumeName"]),
        #
        'ClusterClearBackupStateForSharedVolume': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszVolumePathName"]),
        #
        'ResUtilSetResourceServiceStartParametersEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="LOG_LEVEL"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ResourceHandle", "LogLevel", "FormatString"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszServiceName", "schSCMHandle", "phService", "dwDesiredAccess", "pfnLogEvent", "hResourceHandle"]),
        #
        'ResUtilEnumResourcesEx2': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hSelf", "lpszResTypeName", "pResCallBack", "pParameter", "dwDesiredAccess"]),
        #
        'ResUtilGetResourceDependencyEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hSelf", "lpszResourceType", "dwDesiredAccess"]),
        #
        'ResUtilGetResourceDependencyByNameEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "hSelf", "lpszResourceType", "bRecurse", "dwDesiredAccess"]),
        #
        'ResUtilGetResourceDependencyByClassEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"Anonymous": SimUnion({"dw": SimTypeInt(signed=False, label="UInt32"), "rc": SimTypeInt(signed=False, label="CLUSTER_RESOURCE_CLASS")}, name="<anon>", label="None"), "SubClass": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "li": SimTypeBottom(label="ULARGE_INTEGER")}, name="<anon>", label="None")}, name="CLUS_RESOURCE_CLASS_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["hCluster", "hSelf", "prci", "bRecurse", "dwDesiredAccess"]),
        #
        'ResUtilGetResourceNameDependencyEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), arg_names=["lpszResourceName", "lpszResourceType", "dwDesiredAccess"]),
        #
        'ResUtilGetCoreClusterResourcesEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusterIn", "phClusterNameResourceOut", "phClusterQuorumResourceOut", "dwDesiredAccess"]),
        #
        'OpenClusterCryptProvider': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HCLUSCRYPTPROVIDER", pack=False, align=None), offset=0), arg_names=["lpszResource", "lpszProvider", "dwType", "dwFlags"]),
        #
        'OpenClusterCryptProviderEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({}, name="_HCLUSCRYPTPROVIDER", pack=False, align=None), offset=0), arg_names=["lpszResource", "lpszKeyname", "lpszProvider", "dwType", "dwFlags"]),
        #
        'CloseClusterCryptProvider': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSCRYPTPROVIDER", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusCryptProvider"]),
        #
        'ClusterEncrypt': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSCRYPTPROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusCryptProvider", "pData", "cbData", "ppData", "pcbData"]),
        #
        'ClusterDecrypt': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSCRYPTPROVIDER", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hClusCryptProvider", "pCryptInput", "cbCryptInput", "ppCryptOutput", "pcbCryptOutput"]),
        #
        'FreeClusterCrypt': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pCryptInfo"]),
        #
        'ResUtilPaxosComparer': SimTypeFunction([SimTypePointer(SimStruct({"__padding__PaxosTagVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryNextEpoch": SimTypeInt(signed=False, label="UInt32"), "__padding__EpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__Epoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryEpoch": SimTypeInt(signed=False, label="UInt32"), "Sequence": SimTypeInt(signed=True, label="Int32"), "__padding__BoundrySequence": SimTypeInt(signed=False, label="UInt32")}, name="PaxosTagCStruct", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"__padding__PaxosTagVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryNextEpoch": SimTypeInt(signed=False, label="UInt32"), "__padding__EpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__Epoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryEpoch": SimTypeInt(signed=False, label="UInt32"), "Sequence": SimTypeInt(signed=True, label="Int32"), "__padding__BoundrySequence": SimTypeInt(signed=False, label="UInt32")}, name="PaxosTagCStruct", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["left", "right"]),
        #
        'ResUtilLeftPaxosIsLessThanRight': SimTypeFunction([SimTypePointer(SimStruct({"__padding__PaxosTagVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryNextEpoch": SimTypeInt(signed=False, label="UInt32"), "__padding__EpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__Epoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryEpoch": SimTypeInt(signed=False, label="UInt32"), "Sequence": SimTypeInt(signed=True, label="Int32"), "__padding__BoundrySequence": SimTypeInt(signed=False, label="UInt32")}, name="PaxosTagCStruct", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"__padding__PaxosTagVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__NextEpoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "NextEpoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryNextEpoch": SimTypeInt(signed=False, label="UInt32"), "__padding__EpochVtable": SimTypeLongLong(signed=False, label="UInt64"), "__padding__Epoch_DateTimeVtable": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_DateTime_ticks": SimTypeLongLong(signed=False, label="UInt64"), "Epoch_Value": SimTypeInt(signed=True, label="Int32"), "__padding__BoundryEpoch": SimTypeInt(signed=False, label="UInt32"), "Sequence": SimTypeInt(signed=True, label="Int32"), "__padding__BoundrySequence": SimTypeInt(signed=False, label="UInt32")}, name="PaxosTagCStruct", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["left", "right"]),
        #
        'ResUtilsDeleteKeyTree': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["key", "keyName", "treatNoKeyAsError"]),
        #
        'ResUtilGroupsEqual': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hSelf", "hGroup", "pEqual"]),
        #
        'ResUtilEnumGroups': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hSelf", "pResCallBack", "pParameter"]),
        #
        'ResUtilEnumGroupsEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLUSGROUP_TYPE"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "hSelf", "groupType", "pResCallBack", "pParameter"]),
        #
        'ResUtilDupGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["group", "copy"]),
        #
        'ResUtilGetClusterGroupType': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="CLUSGROUP_TYPE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hGroup", "groupType"]),
        #
        'ResUtilGetCoreGroup': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({}, name="_HGROUP", pack=False, align=None), offset=0), arg_names=["hCluster"]),
        #
        'ResUtilResourceDepEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hSelf", "enumType", "pResCallBack", "pParameter"]),
        #
        'ResUtilDupResource': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="_HRESOURCE", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["group", "copy"]),
        #
        'ResUtilGetClusterId': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "guid"]),
        #
        'ResUtilNodeEnum': SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({}, name="_HCLUSTER", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="_HNODE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="CLUSTER_NODE_STATE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hCluster", "pNodeCallBack", "pParameter"]),
    }

lib.set_prototypes(prototypes)
