/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

public class Validation {
    private static final String[] invalidIdentifiers = new String[]{"_", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final boolean SKIP_IDENTIFIER_CHECK = Boolean.getBoolean("org.apache.el.parser.SKIP_IDENTIFIER_CHECK");

    private Validation() {
    }

    public static boolean isIdentifier(String key) {
        if (SKIP_IDENTIFIER_CHECK) {
            return true;
        }
        if (key == null || key.length() == 0) {
            return false;
        }
        int i = 0;
        int j = invalidIdentifiers.length;
        while (i < j) {
            int k = i + j >>> 1;
            int result = invalidIdentifiers[k].compareTo(key);
            if (result == 0) {
                return false;
            }
            if (result < 0) {
                i = k + 1;
                continue;
            }
            j = k;
        }
        return key.charAt(0) != '#';
    }
}

