/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.projection.CodeProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.CustomProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.GaussKruegerProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertCC9ZonesProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.PuwgProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SingleProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.preferences.projection.SwissGridProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMFranceDOMProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMProjectionChoice;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class ProjectionPreference
implements SubPreferenceSetting {
    private static final List<ProjectionChoice> projectionChoices = new ArrayList<ProjectionChoice>();
    private static final Map<String, ProjectionChoice> projectionChoicesById = new HashMap<String, ProjectionChoice>();
    public static final ProjectionChoice wgs84 = ProjectionPreference.registerProjectionChoice(I18n.tr("WGS84 Geographic", new Object[0]), "core:wgs84", 4326);
    public static final ProjectionChoice mercator = ProjectionPreference.registerProjectionChoice(I18n.tr("Mercator", new Object[0]), "core:mercator", 3857);
    public static final ProjectionChoice lambert = new LambertProjectionChoice();
    public static final ProjectionChoice utm_france_dom = new UTMFranceDOMProjectionChoice();
    public static final ProjectionChoice lambert_cc9 = new LambertCC9ZonesProjectionChoice();
    private static String projectionChoice;
    private static final StringProperty PROP_PROJECTION_DEFAULT;
    private static final StringProperty PROP_COORDINATES;
    private static final ListProperty PROP_SUB_PROJECTION_DEFAULT;
    private static final String[] unitsValues;
    private static final String[] unitsValuesTr;
    private final JosmComboBox<ProjectionChoice> projectionCombo;
    private final JosmComboBox<ICoordinateFormat> coordinatesCombo;
    private final JosmComboBox<String> unitsCombo = new JosmComboBox<String>(unitsValuesTr);
    private JPanel projSubPrefPanel;
    private final JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private final JLabel projectionCodeLabel = new JLabel(I18n.tr("Projection code", new Object[0]));
    private final Component projectionCodeGlue = GBC.glue(5, 0);
    private final JLabel projectionCode = new JLabel();
    private final JLabel projectionNameLabel = new JLabel(I18n.tr("Projection name", new Object[0]));
    private final Component projectionNameGlue = GBC.glue(5, 0);
    private final JLabel projectionName = new JLabel();
    private final JLabel bounds = new JLabel();
    private final VerticallyScrollablePanel projPanel = new VerticallyScrollablePanel(new GridBagLayout());
    private static final GBC projSubPrefPanelGBC;

    public static void registerProjectionChoice(ProjectionChoice c) {
        projectionChoices.add(c);
        projectionChoicesById.put(c.getId(), c);
        for (String code : c.allCodes()) {
            Projections.registerProjectionSupplier(code, () -> {
                Collection<String> pref = c.getPreferencesFromCode(code);
                c.setPreferences(pref);
                try {
                    return c.getProjection();
                }
                catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                    Logging.log(Logging.LEVEL_WARN, "Unable to get projection " + code + " with " + c + ':', e);
                    return null;
                }
            });
        }
    }

    private static ProjectionChoice registerProjectionChoice(String name, String id, Integer epsg) {
        SingleProjectionChoice pc = new SingleProjectionChoice(name, id, "EPSG:" + epsg);
        ProjectionPreference.registerProjectionChoice(pc);
        return pc;
    }

    public static List<ProjectionChoice> getProjectionChoices() {
        return Collections.unmodifiableList(projectionChoices);
    }

    public ProjectionPreference() {
        this.projectionCombo = new JosmComboBox<ProjectionChoice>(projectionChoices.toArray(new ProjectionChoice[0]));
        this.coordinatesCombo = new JosmComboBox<ICoordinateFormat>(CoordinateFormatManager.getCoordinateFormats().toArray(new ICoordinateFormat[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        int i;
        ProjectionChoice pc = this.setupProjectionCombo();
        for (i = 0; i < this.coordinatesCombo.getItemCount(); ++i) {
            if (!((ICoordinateFormat)this.coordinatesCombo.getItemAt(i)).getId().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < unitsValues.length; ++i) {
            if (!unitsValues[i].equals(SystemOfMeasurement.PROP_SYSTEM_OF_MEASUREMENT.get())) continue;
            this.unitsCombo.setSelectedIndex(i);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projectionCodeLabel, GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(this.projectionCodeGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projectionNameLabel, GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(this.projectionNameGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionName, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds", new Object[0])), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.projectionCodeLabel.setLabelFor(this.projectionCode);
        this.projectionNameLabel.setLabelFor(this.projectionName);
        JButton btnSetAsDefault = new JButton(I18n.tr("Set as default", new Object[0]));
        this.projPanel.add((Component)btnSetAsDefault, GBC.eol().insets(5, 10, 5, 5));
        btnSetAsDefault.addActionListener(e -> {
            ProjectionChoice pc2 = (ProjectionChoice)this.projectionCombo.getSelectedItem();
            String id = pc2.getId();
            Collection<String> prefs = pc2.getPreferences(this.projSubPrefPanel);
            ProjectionPreference.setProjection(id, prefs, true);
            pc2.setPreferences(prefs);
            Projection proj = pc2.getProjection();
            new ExtendedDialog((Component)gui, I18n.tr("Default projection", new Object[0]), I18n.tr("OK", new Object[0])).setButtonIcons("ok").setIcon(1).setContent(I18n.tr("Default projection has been set to ''{0}''", proj.toCode())).showDialog();
        });
        ExpertToggleAction.addVisibilitySwitcher(btnSetAsDefault);
        this.projPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 10));
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("System of measurement", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add(this.unitsCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add(GBC.glue(1, 1), GBC.std().fill(2).weight(1.0, 1.0));
        gui.getMapPreference().addSubTab(this, I18n.tr("Map Projection", new Object[0]), this.projPanel.getVerticalScrollPane());
        this.selectedProjectionChanged(pc);
    }

    private void updateMeta(ProjectionChoice pc) {
        pc.setPreferences(pc.getPreferences(this.projSubPrefPanel));
        Projection proj = pc.getProjection();
        this.projectionCode.setText(proj.toCode());
        this.projectionName.setText(proj.toString());
        Bounds b = proj.getWorldBoundsLatLon();
        ICoordinateFormat cf = CoordinateFormatManager.getDefaultFormat();
        this.bounds.setText(cf.lonToString(b.getMin()) + ", " + cf.latToString(b.getMin()) + " : " + cf.lonToString(b.getMax()) + ", " + cf.latToString(b.getMax()));
        boolean showCode = true;
        boolean showName = false;
        if (pc instanceof SubPrefsOptions) {
            showCode = ((SubPrefsOptions)((Object)pc)).showProjectionCode();
            showName = ((SubPrefsOptions)((Object)pc)).showProjectionName();
        }
        this.projectionCodeLabel.setVisible(showCode);
        this.projectionCodeGlue.setVisible(showCode);
        this.projectionCode.setVisible(showCode);
        this.projectionNameLabel.setVisible(showName);
        this.projectionNameGlue.setVisible(showName);
        this.projectionName.setVisible(showName);
    }

    @Override
    public boolean ok() {
        ProjectionChoice pc = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        String id = pc.getId();
        Collection<String> prefs = pc.getPreferences(this.projSubPrefPanel);
        ProjectionPreference.setProjection(id, prefs, false);
        if (PROP_COORDINATES.put(((ICoordinateFormat)this.coordinatesCombo.getSelectedItem()).getId())) {
            CoordinateFormatManager.setCoordinateFormat((ICoordinateFormat)this.coordinatesCombo.getSelectedItem());
        }
        int i = this.unitsCombo.getSelectedIndex();
        SystemOfMeasurement.setSystemOfMeasurement(unitsValues[i]);
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION_DEFAULT.get(), (Collection<String>)PROP_SUB_PROJECTION_DEFAULT.get(), false);
    }

    public static void setProjection(String id, Collection<String> pref, boolean makeDefault) {
        ProjectionChoice pc = projectionChoicesById.get(id);
        if (pc == null) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The projection {0} could not be activated. Using Mercator", id), I18n.tr("Error", new Object[0]), 0);
            pref = null;
            pc = mercator;
        }
        id = pc.getId();
        Config.getPref().putList("projection.sub." + id, (List<String>)(pref == null ? null : new ArrayList<String>(pref)));
        if (makeDefault) {
            PROP_PROJECTION_DEFAULT.put(id);
            PROP_SUB_PROJECTION_DEFAULT.put((List<String>)(pref == null ? null : new ArrayList<String>(pref)));
        } else {
            projectionChoice = id;
        }
        pc.setPreferences(pref);
        Projection proj = pc.getProjection();
        ProjectionRegistry.setProjection(proj);
    }

    private void selectedProjectionChanged(ProjectionChoice pc) {
        int size = this.projPanel.getComponentCount();
        if (size < 1) {
            return;
        }
        ActionListener listener = e -> this.updateMeta(pc);
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanel = pc.getPreferencePanel(listener);
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(pc);
    }

    private ProjectionChoice setupProjectionCombo() {
        String pcId = ProjectionPreference.getCurrentProjectionChoiceId();
        ProjectionChoice pc = null;
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            ProjectionChoice pc1 = (ProjectionChoice)this.projectionCombo.getItemAt(i);
            pc1.setPreferences(ProjectionPreference.getSubprojectionPreference(pc1.getId()));
            if (!pc1.getId().equals(pcId)) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(pc1);
            pc = pc1;
        }
        if (pc == null) {
            throw new JosmRuntimeException("Couldn't find the current projection in the list of available projections!");
        }
        this.projectionCombo.addActionListener(e -> {
            ProjectionChoice pc1 = (ProjectionChoice)this.projectionCombo.getSelectedItem();
            this.selectedProjectionChanged(pc1);
        });
        return pc;
    }

    public static String getCurrentProjectionChoiceId() {
        return projectionChoice != null ? projectionChoice : PROP_PROJECTION_DEFAULT.get();
    }

    public static Collection<String> getSubprojectionPreference(String pcId) {
        return Config.getPref().getList("projection.sub." + pcId, null);
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getMapPreference();
    }

    public void selectProjection(ProjectionChoice projection) {
        if (this.projectionCombo != null && projection != null) {
            this.projectionCombo.setSelectedItem(projection);
        }
    }

    static {
        ProjectionPreference.registerProjectionChoice(new UTMProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 1972", new Object[0]), "core:belgianLambert1972", 31370);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Belgian Lambert 2008", new Object[0]), "core:belgianLambert2008", 3812);
        ProjectionPreference.registerProjectionChoice(new SwissGridProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new GaussKruegerProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert Zone (Estonia)", new Object[0]), "core:lambertest", 3301);
        ProjectionPreference.registerProjectionChoice(lambert);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Lambert 93 (France)", new Object[0]), "core:lambert93", 2154);
        ProjectionPreference.registerProjectionChoice(lambert_cc9);
        ProjectionPreference.registerProjectionChoice(utm_france_dom);
        ProjectionPreference.registerProjectionChoice(I18n.tr("LKS-92 (Latvia TM)", new Object[0]), "core:tmerclv", 3059);
        ProjectionPreference.registerProjectionChoice(I18n.tr("Rijksdriehoeksco\u00f6rdinaten (Netherlands)", new Object[0]), "core:dutchrd", 28992);
        ProjectionPreference.registerProjectionChoice(new PuwgProjectionChoice());
        ProjectionPreference.registerProjectionChoice(I18n.tr("SWEREF99 13 30 / EPSG:3008 (Sweden)", new Object[0]), "core:sweref99", 3008);
        ProjectionPreference.registerProjectionChoice(new CodeProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new CustomProjectionChoice());
        PROP_PROJECTION_DEFAULT = new StringProperty("projection.default", mercator.getId());
        PROP_COORDINATES = new StringProperty("coordinates", null);
        PROP_SUB_PROJECTION_DEFAULT = new ListProperty("projection.default.sub", null);
        unitsValues = SystemOfMeasurement.ALL_SYSTEMS.keySet().toArray(new String[SystemOfMeasurement.ALL_SYSTEMS.size()]);
        unitsValuesTr = new String[unitsValues.length];
        for (int i = 0; i < unitsValues.length; ++i) {
            ProjectionPreference.unitsValuesTr[i] = I18n.tr(unitsValues[i], new Object[0]);
        }
        projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

