/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.AbstractStaxSamlMetadataParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLEncryptionMethodParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;

public class SAMLKeyDescriptorParser
extends AbstractStaxSamlMetadataParser<KeyDescriptorType> {
    private static final SAMLKeyDescriptorParser INSTANCE = new SAMLKeyDescriptorParser();

    public SAMLKeyDescriptorParser() {
        super(SAMLMetadataQNames.KEY_DESCRIPTOR);
    }

    public static SAMLKeyDescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected KeyDescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        String use = StaxParserUtil.getAttributeValue(element, SAMLMetadataQNames.ATTR_USE);
        if (use != null && !use.isEmpty()) {
            keyDescriptor.setUse(KeyTypes.fromValue((String)use));
        }
        return keyDescriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, KeyDescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case KEY_INFO: {
                target.setKeyInfo(StaxParserUtil.getDOMElement(xmlEventReader));
                break;
            }
            case ENCRYPTION_METHOD: {
                target.addEncryptionMethod((EncryptionMethodType)SAMLEncryptionMethodParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

