/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.log;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.tools.log.AtomicActionTypeMap;
import com.arjuna.ats.internal.arjuna.tools.log.EditableTransaction;
import java.util.HashMap;

public class TransactionTypeManager {
    private HashMap<String, TransactionTypeMap> _maps = new HashMap();
    private static final TransactionTypeManager _manager = new TransactionTypeManager();

    public EditableTransaction getTransaction(String type, Uid u) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        TransactionTypeMap map = this._maps.get(type);
        if (map != null) {
            return map.getTransaction(u);
        }
        return null;
    }

    public String getTransactionType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        TransactionTypeMap map = this._maps.get(type);
        if (map != null) {
            return map.getRealType();
        }
        return null;
    }

    public boolean present(String type) {
        return this._maps.get(type) != null;
    }

    public void addTransaction(TransactionTypeMap map) {
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this._maps.put(map.getType(), map);
    }

    public void removeTransaction(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this._maps.remove(type);
    }

    public static TransactionTypeManager getInstance() {
        return _manager;
    }

    private TransactionTypeManager() {
        this.addTransaction(new AtomicActionTypeMap());
    }

    public static interface TransactionTypeMap {
        public EditableTransaction getTransaction(Uid var1);

        public String getType();

        public String getRealType();
    }
}

