/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(38, 35) * ivec2(38, 35)) => ivec2(1444, 1225)
 * (ivec2(38, 35) * ivec2(64, -9)) => ivec2(2432, -315)
 * (ivec2(38, 35) * ivec2(64, 9)) => ivec2(2432, 315)
 * (ivec2(64, -9) * ivec2(38, 35)) => ivec2(2432, -315)
 * (ivec2(64, -9) * ivec2(64, -9)) => ivec2(4096, 81)
 * (ivec2(64, -9) * ivec2(64, 9)) => ivec2(4096, -81)
 * (ivec2(64, 9) * ivec2(38, 35)) => ivec2(2432, 315)
 * (ivec2(64, 9) * ivec2(64, -9)) => ivec2(4096, -81)
 * (ivec2(64, 9) * ivec2(64, 9)) => ivec2(4096, 81)
 */
#version 120

void main()
{
  float[all(equal((ivec2(38, 35) * ivec2(38, 35)), ivec2(1444, 1225))) ? 1 : -1] array0;
  float[all(equal((ivec2(38, 35) * ivec2(64, -9)), ivec2(2432, -315))) ? 1 : -1] array1;
  float[all(equal((ivec2(38, 35) * ivec2(64, 9)), ivec2(2432, 315))) ? 1 : -1] array2;
  float[all(equal((ivec2(64, -9) * ivec2(38, 35)), ivec2(2432, -315))) ? 1 : -1] array3;
  float[all(equal((ivec2(64, -9) * ivec2(64, -9)), ivec2(4096, 81))) ? 1 : -1] array4;
  float[all(equal((ivec2(64, -9) * ivec2(64, 9)), ivec2(4096, -81))) ? 1 : -1] array5;
  float[all(equal((ivec2(64, 9) * ivec2(38, 35)), ivec2(2432, 315))) ? 1 : -1] array6;
  float[all(equal((ivec2(64, 9) * ivec2(64, -9)), ivec2(4096, -81))) ? 1 : -1] array7;
  float[all(equal((ivec2(64, 9) * ivec2(64, 9)), ivec2(4096, 81))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
