/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;

public class Coordinates {
    public static Coordinate create(int dimension) {
        return Coordinates.create(dimension, 0);
    }

    public static Coordinate create(int dimension, int measures) {
        if (dimension == 2) {
            return new CoordinateXY();
        }
        if (dimension == 3 && measures == 0) {
            return new Coordinate();
        }
        if (dimension == 3 && measures == 1) {
            return new CoordinateXYM();
        }
        if (dimension == 4 && measures == 1) {
            return new CoordinateXYZM();
        }
        return new Coordinate();
    }

    public static int dimension(Coordinate coordinate) {
        if (coordinate instanceof CoordinateXY) {
            return 2;
        }
        if (coordinate instanceof CoordinateXYM) {
            return 3;
        }
        if (coordinate instanceof CoordinateXYZM) {
            return 4;
        }
        if (coordinate instanceof Coordinate) {
            return 3;
        }
        return 3;
    }

    public static boolean hasZ(Coordinate coordinate) {
        if (coordinate instanceof CoordinateXY) {
            return false;
        }
        if (coordinate instanceof CoordinateXYM) {
            return false;
        }
        if (coordinate instanceof CoordinateXYZM) {
            return true;
        }
        if (coordinate instanceof Coordinate) {
            return true;
        }
        return true;
    }

    public static int measures(Coordinate coordinate) {
        if (coordinate instanceof CoordinateXY) {
            return 0;
        }
        if (coordinate instanceof CoordinateXYM) {
            return 1;
        }
        if (coordinate instanceof CoordinateXYZM) {
            return 1;
        }
        if (coordinate instanceof Coordinate) {
            return 0;
        }
        return 0;
    }
}

