/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.encoding;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.annotation.PropertyName;
import com.google.cloud.firestore.encoding.BeanMapper;
import com.google.cloud.firestore.encoding.DeserializeContext;
import com.google.cloud.firestore.encoding.PojoBeanMapper;
import com.google.cloud.firestore.encoding.RecordMapper;
import com.google.firestore.v1.Value;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class CustomClassMapper {
    private static final int MAX_DEPTH = 500;
    private static final ConcurrentMap<Class<?>, BeanMapper<?>> mappers = new ConcurrentHashMap();

    public static Object convertToPlainJavaTypes(Object object) {
        return CustomClassMapper.serialize(object);
    }

    public static Map<String, Object> convertToPlainJavaTypes(Map<?, Object> update) {
        Object converted = CustomClassMapper.serialize(update);
        CustomClassMapper.hardAssert(converted instanceof Map);
        Map convertedMap = (Map)converted;
        return convertedMap;
    }

    public static <T> T convertToCustomClass(Object object, Class<T> clazz, DocumentReference docRef) {
        return CustomClassMapper.deserializeToClass(object, clazz, new DeserializeContext(DeserializeContext.ErrorPath.EMPTY, docRef));
    }

    public static <T> Object serialize(T o) {
        return CustomClassMapper.serialize(o, DeserializeContext.ErrorPath.EMPTY);
    }

    static <T> Object serialize(T o, DeserializeContext.ErrorPath path) {
        if (path.getLength() > 500) {
            throw path.serializeError("Exceeded maximum depth of 500, which likely indicates there's an object cycle");
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            if (o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return String.valueOf(o);
            }
            throw path.serializeError(String.format("Numbers of type %s are not supported, please use an int, long, float, double or BigDecimal", o.getClass().getSimpleName()));
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Character) {
            throw path.serializeError("Characters are not supported, please use Strings");
        }
        if (o instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    String keyString = (String)key;
                    result.put(keyString, CustomClassMapper.serialize(entry.getValue(), path.child(keyString)));
                    continue;
                }
                throw path.serializeError("Maps with non-string keys are not supported");
            }
            return result;
        }
        if (o instanceof Collection) {
            if (o instanceof List) {
                List list = (List)o;
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    result.add(CustomClassMapper.serialize(list.get(i), path.child("[" + i + "]")));
                }
                return result;
            }
            throw path.serializeError("Serializing Collections is not supported, please use Lists instead");
        }
        if (o.getClass().isArray()) {
            throw path.serializeError("Serializing Arrays is not supported, please use Lists instead");
        }
        if (o instanceof Enum) {
            String enumName = ((Enum)o).name();
            try {
                Field enumField = o.getClass().getField(enumName);
                return CustomClassMapper.propertyName(enumField);
            }
            catch (NoSuchFieldException ex) {
                return enumName;
            }
        }
        if (o instanceof Date || o instanceof Timestamp || o instanceof GeoPoint || o instanceof Blob || o instanceof DocumentReference || o instanceof FieldValue || o instanceof Value || o instanceof VectorValue) {
            return o;
        }
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return Timestamp.ofTimeSecondsAndNanos((long)instant.getEpochSecond(), (int)instant.getNano());
        }
        Class<?> clazz = o.getClass();
        BeanMapper<?> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        return mapper.serialize(o, path);
    }

    static <T> T deserializeToType(Object o, Type type, DeserializeContext context) {
        if (o == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            return CustomClassMapper.deserializeToParameterizedType(o, (ParameterizedType)type, context);
        }
        if (type instanceof Class) {
            return CustomClassMapper.deserializeToClass(o, (Class)type, context);
        }
        if (type instanceof WildcardType) {
            Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
            if (lowerBounds.length > 0) {
                throw context.errorPath.deserializeError("Generic lower-bounded wildcard types are not supported");
            }
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            CustomClassMapper.hardAssert(upperBounds.length > 0, "Unexpected type bounds on wildcard " + type);
            return CustomClassMapper.deserializeToType(o, upperBounds[0], context);
        }
        if (type instanceof TypeVariable) {
            Type[] upperBounds = ((TypeVariable)type).getBounds();
            CustomClassMapper.hardAssert(upperBounds.length > 0, "Unexpected type bounds on type variable " + type);
            return CustomClassMapper.deserializeToType(o, upperBounds[0], context);
        }
        if (type instanceof GenericArrayType) {
            throw context.errorPath.deserializeError("Generic Arrays are not supported, please use Lists instead");
        }
        throw context.errorPath.deserializeError("Unknown type encountered: " + type);
    }

    private static <T> T deserializeToParameterizedType(Object o, ParameterizedType type, DeserializeContext context) {
        Class rawType = (Class)type.getRawType();
        if (List.class.isAssignableFrom(rawType)) {
            Type genericType = type.getActualTypeArguments()[0];
            if (o instanceof List) {
                ArrayList<T> result;
                List list = (List)o;
                try {
                    result = rawType == List.class ? new ArrayList<T>(list.size()) : (List)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw context.errorPath.deserializeError(String.format("Unable to deserialize to %s: %s", rawType.getSimpleName(), e.toString()));
                }
                for (int i = 0; i < list.size(); ++i) {
                    result.add(CustomClassMapper.deserializeToType(list.get(i), genericType, context.newInstanceWithErrorPath(context.errorPath.child("[" + i + "]"))));
                }
                return (T)result;
            }
            throw context.errorPath.deserializeError("Expected a List, but got a " + o.getClass());
        }
        if (Map.class.isAssignableFrom(rawType)) {
            HashMap result;
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (!keyType.equals(String.class)) {
                throw context.errorPath.deserializeError("Only Maps with string keys are supported, but found Map with key type " + keyType);
            }
            Map<String, Object> map = CustomClassMapper.expectMap(o, context.errorPath);
            try {
                result = rawType == Map.class ? new HashMap() : (HashMap)rawType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw context.errorPath.deserializeError(String.format("Unable to deserialize to %s: %s", rawType.getSimpleName(), e.toString()));
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result.put(entry.getKey(), CustomClassMapper.deserializeToType(entry.getValue(), valueType, context.newInstanceWithErrorPath(context.errorPath.child(entry.getKey()))));
            }
            return (T)result;
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            throw context.errorPath.deserializeError("Collections are not supported, please use Lists instead");
        }
        Map<String, Object> map = CustomClassMapper.expectMap(o, context.errorPath);
        BeanMapper mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(rawType);
        HashMap typeMapping = new HashMap();
        TypeVariable<Class<T>>[] typeVariables = mapper.getClazz().getTypeParameters();
        Type[] types = type.getActualTypeArguments();
        if (types.length != typeVariables.length) {
            throw new IllegalStateException("Mismatched lengths for type variables and actual types");
        }
        for (int i = 0; i < typeVariables.length; ++i) {
            typeMapping.put(typeVariables[i], types[i]);
        }
        return mapper.deserialize(map, typeMapping, context);
    }

    private static <T> T deserializeToClass(Object o, Class<T> clazz, DeserializeContext context) {
        if (o == null) {
            return null;
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            return CustomClassMapper.deserializeToPrimitive(o, clazz, context.errorPath);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertString(o, context.errorPath);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDate(o, context.errorPath);
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertTimestamp(o, context.errorPath);
        }
        if (Instant.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInstant(o, context.errorPath);
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBlob(o, context.errorPath);
        }
        if (GeoPoint.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertGeoPoint(o, context.errorPath);
        }
        if (VectorValue.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertVectorValue(o, context.errorPath);
        }
        if (DocumentReference.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDocumentReference(o, context.errorPath);
        }
        if (clazz.isArray()) {
            throw context.errorPath.deserializeError("Converting to Arrays is not supported, please use Lists instead");
        }
        if (clazz.getTypeParameters().length > 0) {
            throw context.errorPath.deserializeError("Class " + clazz.getName() + " has generic type parameters, please use GenericTypeIndicator instead");
        }
        if (clazz.equals(Object.class)) {
            return (T)o;
        }
        if (clazz.isEnum()) {
            return CustomClassMapper.deserializeToEnum(o, clazz, context.errorPath);
        }
        return CustomClassMapper.convertBean(o, clazz, context);
    }

    private static <T> T convertBean(Object o, Class<T> clazz, DeserializeContext context) {
        BeanMapper<T> mapper = CustomClassMapper.loadOrCreateBeanMapperForClass(clazz);
        if (o instanceof Map) {
            return mapper.deserialize(CustomClassMapper.expectMap(o, context.errorPath), context);
        }
        throw context.errorPath.deserializeError("Can't convert object of type " + o.getClass().getName() + " to type " + clazz.getName());
    }

    private static <T> BeanMapper<T> loadOrCreateBeanMapperForClass(Class<T> clazz) {
        BeanMapper mapper = (RecordMapper<T>)mappers.get(clazz);
        if (mapper == null) {
            mapper = CustomClassMapper.isRecordType(clazz) ? new RecordMapper<T>(clazz) : new PojoBeanMapper<T>(clazz);
            mappers.put(clazz, mapper);
        }
        return mapper;
    }

    private static Map<String, Object> expectMap(Object object, DeserializeContext.ErrorPath errorPath) {
        if (object instanceof Map) {
            return (Map)object;
        }
        throw errorPath.deserializeError("Expected a Map while deserializing, but got a " + object.getClass());
    }

    private static <T> T deserializeToPrimitive(Object o, Class<T> clazz, DeserializeContext.ErrorPath errorPath) {
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertInteger(o, errorPath);
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBoolean(o, errorPath);
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertDouble(o, errorPath);
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertLong(o, errorPath);
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return (T)CustomClassMapper.convertBigDecimal(o, errorPath);
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return (T)Float.valueOf(CustomClassMapper.convertDouble(o, errorPath).floatValue());
        }
        throw errorPath.deserializeError(String.format("Deserializing values to %s is not supported", clazz.getSimpleName()));
    }

    private static <T> T deserializeToEnum(Object object, Class<T> clazz, DeserializeContext.ErrorPath errorPath) {
        if (object instanceof String) {
            Field[] enumFields;
            String value = (String)object;
            for (Field field : enumFields = clazz.getFields()) {
                String propertyName;
                if (!field.isEnumConstant() || !value.equals(propertyName = CustomClassMapper.propertyName(field))) continue;
                value = field.getName();
                break;
            }
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                throw errorPath.deserializeError("Could not find enum value of " + clazz.getName() + " for value \"" + value + "\"");
            }
        }
        throw errorPath.deserializeError("Expected a String while deserializing to enum " + clazz + " but got a " + object.getClass());
    }

    private static Integer convertInteger(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Long || o instanceof Double) {
            double value = ((Number)o).doubleValue();
            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                return ((Number)o).intValue();
            }
            throw errorPath.deserializeError("Numeric value out of 32-bit integer range: " + value + ". Did you mean to use a long or double instead of an int?");
        }
        throw errorPath.deserializeError("Failed to convert a value of type " + o.getClass().getName() + " to int");
    }

    private static Long convertLong(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Double) {
            Double value = (Double)o;
            if (value >= -9.223372036854776E18 && value <= 9.223372036854776E18) {
                return value.longValue();
            }
            throw errorPath.deserializeError("Numeric value out of 64-bit long range: " + value + ". Did you mean to use a double instead of a long?");
        }
        throw errorPath.deserializeError("Failed to convert a value of type " + o.getClass().getName() + " to long");
    }

    private static Double convertDouble(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Long) {
            Long value = (Long)o;
            Double doubleValue = ((Long)o).doubleValue();
            if (doubleValue.longValue() == value.longValue()) {
                return doubleValue;
            }
            throw errorPath.deserializeError("Loss of precision while converting number to double: " + o + ". Did you mean to use a 64-bit long instead?");
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw errorPath.deserializeError("Failed to convert a value of type " + o.getClass().getName() + " to double");
    }

    private static BigDecimal convertBigDecimal(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Integer) {
            return BigDecimal.valueOf(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return BigDecimal.valueOf((Long)o);
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o).abs();
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof String) {
            return new BigDecimal((String)o);
        }
        throw errorPath.deserializeError("Failed to convert a value of type " + o.getClass().getName() + " to BigDecimal");
    }

    private static Boolean convertBoolean(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to boolean");
    }

    private static String convertString(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof String) {
            return (String)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to String");
    }

    private static Date convertDate(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Timestamp) {
            return ((Timestamp)o).toDate();
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to Date");
    }

    private static Timestamp convertTimestamp(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof Date) {
            return Timestamp.of((Date)((Date)o));
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to Timestamp");
    }

    private static Instant convertInstant(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)o;
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }
        if (o instanceof Date) {
            return Instant.ofEpochMilli(((Date)o).getTime());
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to Instant");
    }

    private static Blob convertBlob(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof Blob) {
            return (Blob)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to Blob");
    }

    private static GeoPoint convertGeoPoint(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof GeoPoint) {
            return (GeoPoint)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to GeoPoint");
    }

    private static VectorValue convertVectorValue(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof VectorValue) {
            return (VectorValue)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to VectorValue");
    }

    private static DocumentReference convertDocumentReference(Object o, DeserializeContext.ErrorPath errorPath) {
        if (o instanceof DocumentReference) {
            return (DocumentReference)o;
        }
        throw errorPath.deserializeError("Failed to convert value of type " + o.getClass().getName() + " to DocumentReference");
    }

    private static boolean isRecordType(Class<?> cls) {
        Class<?> parent = cls.getSuperclass();
        return parent != null && "java.lang.Record".equals(parent.getName());
    }

    private static String propertyName(Field field) {
        String annotatedName = CustomClassMapper.annotatedName(field);
        return annotatedName != null ? annotatedName : field.getName();
    }

    private static String annotatedName(AccessibleObject obj) {
        if (obj.isAnnotationPresent(PropertyName.class)) {
            PropertyName annotation = obj.getAnnotation(PropertyName.class);
            return annotation.value();
        }
        return null;
    }

    private static void hardAssert(boolean assertion) {
        CustomClassMapper.hardAssert(assertion, "Internal inconsistency");
    }

    private static void hardAssert(boolean assertion, String message) {
        if (!assertion) {
            throw new RuntimeException("Hard assert failed: " + message);
        }
    }
}

