/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import org.traccar.helper.LogAction;
import org.traccar.helper.WebHelper;
import org.traccar.model.User;

public final class SessionHelper {
    public static final String USER_ID_KEY = "userId";
    public static final String EXPIRATION_KEY = "expiration";

    private SessionHelper() {
    }

    public static void userLogin(HttpServletRequest request, User user, Date expiration) {
        request.getSession().invalidate();
        request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
        if (expiration != null) {
            request.getSession().setAttribute(EXPIRATION_KEY, (Object)expiration);
        }
        LogAction.login(user.getId(), WebHelper.retrieveRemoteAddress(request));
    }
}

