/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class GoSafeProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("*GS").number("d+,").number("(d+),").expression("([^#]*)#?").compile();
    private static final Pattern PATTERN_OLD = new PatternBuilder().text("*GS").number("d+,").number("(d+),").text("GPS:").number("(dd)(dd)(dd);").number("d;").optional().expression("([AV]);").number("([NS])(d+.d+);").number("([EW])(d+.d+);").number("(d+)?;").number("(d+);").number("(d+.?d*)").optional().number("(dd)(dd)(dd)").any().compile();

    public GoSafeProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeTextFragment(Position position, String fragment) {
        int dataIndex = fragment.indexOf(58);
        int index = 0;
        String[] values = fragment.length() == dataIndex + 1 ? new String[]{} : fragment.substring(dataIndex + 1).split(";");
        switch (fragment.substring(0, dataIndex)) {
            case "GPS": {
                position.setValid(values[index++].equals("A"));
                position.set("sat", Integer.parseInt(values[index++]));
                position.setLatitude(Double.parseDouble(values[index].substring(1)));
                if (values[index++].charAt(0) == 'S') {
                    position.setLatitude(-position.getLatitude());
                }
                position.setLongitude(Double.parseDouble(values[index].substring(1)));
                if (values[index++].charAt(0) == 'W') {
                    position.setLongitude(-position.getLongitude());
                }
                if (!values[index++].isEmpty()) {
                    position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(values[index - 1])));
                }
                position.setCourse(Integer.parseInt(values[index++]));
                if (index < values.length && !values[index++].isEmpty()) {
                    position.setAltitude(Integer.parseInt(values[index - 1]));
                }
                if (index < values.length && !values[index++].isEmpty()) {
                    position.set("hdop", Double.parseDouble(values[index - 1]));
                }
                if (index >= values.length || values[index++].isEmpty()) break;
                position.set("vdop", Double.parseDouble(values[index - 1]));
                break;
            }
            case "GSM": {
                ++index;
                int n = ++index;
                int n2 = ++index;
                int n3 = ++index;
                int n4 = ++index;
                int n5 = ++index;
                ++index;
                position.setNetwork(new Network(CellTower.from(Integer.parseInt(values[n]), Integer.parseInt(values[n2]), Integer.parseInt(values[n3], 16), Integer.parseInt(values[n4], 16), Integer.parseInt(values[n5]))));
                break;
            }
            case "COT": {
                if (index < values.length) {
                    position.set("odometer", Long.parseLong(values[index++]));
                }
                if (index >= values.length) break;
                String[] hours = values[index].split("-");
                position.set("hours", (Integer.parseInt(hours[0]) * 3600 + (hours.length > 1 ? Integer.parseInt(hours[1]) * 60 : 0) + (hours.length > 2 ? Integer.parseInt(hours[2]) : 0)) * 1000);
                break;
            }
            case "ADC": {
                position.set("power", Double.parseDouble(values[index++]));
                if (index < values.length) {
                    position.set("battery", Double.parseDouble(values[index++]));
                }
                if (index < values.length) {
                    position.set("adc1", Double.parseDouble(values[index++]));
                }
                if (index >= values.length) break;
                position.set("adc2", Double.parseDouble(values[index++]));
                break;
            }
            case "DTT": {
                position.set("status", Integer.parseInt(values[index++], 16));
                if (!values[index++].isEmpty()) {
                    int io = Integer.parseInt(values[index - 1], 16);
                    position.set("ignition", BitUtil.check(io, 0));
                    position.set("in1", BitUtil.check(io, 1));
                    position.set("in2", BitUtil.check(io, 2));
                    position.set("in3", BitUtil.check(io, 3));
                    position.set("in4", BitUtil.check(io, 4));
                    position.set("out1", BitUtil.check(io, 5));
                    position.set("out2", BitUtil.check(io, 6));
                    position.set("out3", BitUtil.check(io, 7));
                }
                position.set("geofence", values[index++] + values[index++]);
                position.set("eventStatus", values[index++]);
                if (index >= values.length) break;
                position.set("packetType", values[index++]);
                break;
            }
            case "ETD": {
                position.set("eventData", values[index++]);
                break;
            }
            case "OBD": {
                position.set("obd", values[index++]);
                break;
            }
            case "TAG": {
                position.set("tagData", values[index++]);
                break;
            }
            case "IWD": {
                while (index < values.length) {
                    int dataType;
                    int sensorIndex = Integer.parseInt(values[index++]);
                    if ((dataType = Integer.parseInt(values[index++])) == 0) {
                        position.set("driverUniqueId", values[index++]);
                        continue;
                    }
                    if (dataType != 1) continue;
                    int n = ++index;
                    ++index;
                    position.set("temp" + sensorIndex, Double.parseDouble(values[n]));
                }
                break;
            }
        }
    }

    private Position decodeTextPosition(DeviceSession deviceSession, String sentence) throws ParseException {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int index = 0;
        String[] fragments = sentence.split(",");
        if (fragments[index].matches("[0-9]{12}")) {
            position.setTime(new SimpleDateFormat("HHmmssddMMyy").parse(fragments[index++]));
        } else {
            this.getLastLocation(position, null);
            position.set("result", fragments[index++]);
        }
        while (index < fragments.length) {
            if (!fragments[index].isEmpty()) {
                if (fragments[index].matches("\\p{XDigit}+")) {
                    position.set("event", Integer.parseInt(fragments[index], 16));
                } else {
                    this.decodeTextFragment(position, fragments[index]);
                }
            }
            ++index;
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf;
        char marker;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)"1234", (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        if ((marker = (char)(buf = (ByteBuf)msg).getByte(buf.readerIndex())) == '*') {
            return this.decodeText(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
        }
        return this.decodeBinary(channel, remoteAddress, buf);
    }

    private Object decodeText(Channel channel, SocketAddress remoteAddress, String sentence) throws Exception {
        Parser parser;
        Pattern pattern = PATTERN;
        if (sentence.startsWith("*GS02")) {
            pattern = PATTERN_OLD;
        }
        if (!(parser = new Parser(pattern, sentence)).matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        if (pattern == PATTERN_OLD) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setValid(parser.next().equals("A"));
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
            position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
            position.setCourse(parser.nextDouble(0.0));
            position.set("hdop", parser.next());
            dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
            position.setTime(dateBuilder.getDate());
            return position;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        for (String item : parser.next().split("\\$")) {
            positions.add(this.decodeTextPosition(deviceSession, item));
        }
        return positions;
    }

    private Object decodeBinary(Channel channel, SocketAddress remoteAddress, ByteBuf buf) throws Exception {
        int mask;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        String imei = String.valueOf(buf.readUnsignedInt() << 24 | (long)buf.readUnsignedMedium());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        long seconds = buf.readUnsignedInt() + 946684800L;
        position.setTime(new Date(seconds * 1000L));
        if (type == 65) {
            buf.readUnsignedByte();
        }
        if (BitUtil.check(mask = buf.readUnsignedShort(), 0)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 1)) {
            buf.readUnsignedByte();
            int fragmentMask = buf.readUnsignedShort();
            if (BitUtil.check(fragmentMask, 0)) {
                short flags = buf.readUnsignedByte();
                position.setValid(BitUtil.between(flags, 5, 7) > 0);
                position.set("sat", BitUtil.to(flags, 5));
            }
            if (BitUtil.check(fragmentMask, 1)) {
                position.setLatitude((double)buf.readInt() / 1000000.0);
                position.setLongitude((double)buf.readInt() / 1000000.0);
            }
            if (BitUtil.check(fragmentMask, 2)) {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readShort()));
            }
            if (BitUtil.check(fragmentMask, 3)) {
                position.setCourse(buf.readUnsignedShort());
            }
            if (BitUtil.check(fragmentMask, 4)) {
                position.setAltitude(buf.readShort());
            }
            if (BitUtil.check(fragmentMask, 5)) {
                position.set("hdop", (double)buf.readUnsignedShort() / 100.0);
            }
            if (BitUtil.check(fragmentMask, 6)) {
                position.set("vdop", (double)buf.readUnsignedShort() / 100.0);
            }
        } else {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (BitUtil.check(mask, 2)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 3)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 4)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 5)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 6)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        if (BitUtil.check(mask, 7)) {
            buf.skipBytes((int)buf.readUnsignedByte());
        }
        return position;
    }
}

