/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.map.InheritanceTree;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;

public class DexInheritanceFileVisitor
extends DexFileVisitor {
    final InheritanceTree tree;

    public DexInheritanceFileVisitor(InheritanceTree tree) {
        this.tree = tree;
    }

    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        final InheritanceTree.Clz clz = this.tree.addClz(access_flags, className);
        if (clz == null) {
            return null;
        }
        if (superClass != null) {
            clz.relateSuper(superClass);
        }
        if (interfaceNames != null) {
            String[] stringArray = interfaceNames;
            int n = interfaceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                clz.relateInterface(s);
                ++n2;
            }
        }
        return new DexClassVisitor(){

            public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
                clz.addField(accessFlags, field.getName(), field.getType());
                return null;
            }

            public DexMethodVisitor visitMethod(int accessFlags, Method method) {
                clz.addMethod(accessFlags, method.getName(), method.getParameterTypes(), method.getReturnType());
                return null;
            }
        };
    }
}

