/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;
import org.keycloak.services.cors.Cors;

public interface OAuth2GrantType
extends Provider {
    public EventType getEventType();

    default public Set<String> getSupportedMultivaluedRequestParameters() {
        return Collections.emptySet();
    }

    public Response process(Context var1);

    public static class Context {
        protected KeycloakSession session;
        protected RealmModel realm;
        protected ClientModel client;
        protected Object clientConfig;
        protected ClientConnection clientConnection;
        protected Map<String, String> clientAuthAttributes;
        protected HttpRequest request;
        protected HttpResponse response;
        protected HttpHeaders headers;
        protected MultivaluedMap<String, String> formParams;
        protected EventBuilder event;
        protected Cors cors;
        protected Object tokenManager;

        public Context(KeycloakSession session, Object clientConfig, Map<String, String> clientAuthAttributes, MultivaluedMap<String, String> formParams, EventBuilder event, Cors cors, Object tokenManager) {
            this.session = session;
            this.realm = session.getContext().getRealm();
            this.client = session.getContext().getClient();
            this.clientConfig = clientConfig;
            this.clientConnection = session.getContext().getConnection();
            this.clientAuthAttributes = clientAuthAttributes;
            this.request = session.getContext().getHttpRequest();
            this.response = session.getContext().getHttpResponse();
            this.headers = session.getContext().getRequestHeaders();
            this.formParams = formParams;
            this.event = event;
            this.cors = cors;
            this.tokenManager = tokenManager;
        }

        public Context(Context context) {
            this.session = context.session;
            this.realm = context.realm;
            this.client = context.client;
            this.clientConfig = context.clientConfig;
            this.clientConnection = context.clientConnection;
            this.clientAuthAttributes = context.clientAuthAttributes;
            this.request = context.request;
            this.response = context.response;
            this.headers = context.headers;
            this.formParams = context.formParams;
            this.event = context.event;
            this.cors = context.cors;
            this.tokenManager = context.tokenManager;
        }

        public void setFormParams(MultivaluedHashMap<String, String> formParams) {
            this.formParams = formParams;
        }

        public void setClient(ClientModel client) {
            this.client = client;
        }

        public void setClientConfig(Object clientConfig) {
            this.clientConfig = clientConfig;
        }

        public void setClientAuthAttributes(Map<String, String> clientAuthAttributes) {
            this.clientAuthAttributes = clientAuthAttributes;
        }

        public ClientModel getClient() {
            return this.client;
        }

        public Map<String, String> getClientAuthAttributes() {
            return this.clientAuthAttributes;
        }

        public Object getClientConfig() {
            return this.clientConfig;
        }

        public ClientConnection getClientConnection() {
            return this.clientConnection;
        }

        public Cors getCors() {
            return this.cors;
        }

        public EventBuilder getEvent() {
            return this.event;
        }

        public MultivaluedMap<String, String> getFormParams() {
            return this.formParams;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public RealmModel getRealm() {
            return this.realm;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public KeycloakSession getSession() {
            return this.session;
        }

        public Object getTokenManager() {
            return this.tokenManager;
        }
    }
}

