"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowFrameworkDashboardsPlugin = void 0;
var _operators = require("rxjs/operators");
var _cluster = require("./cluster");
var _routes = require("./routes");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class FlowFrameworkDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    this.logger.debug('flow-framework-dashboards: Setup');
    const router = core.http.createRouter();

    // Get global config
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();

    // Create OpenSearch client, including flow framework plugin APIs
    const client = core.opensearch.legacy.createClient('flow_framework', {
      plugins: [_cluster.flowFrameworkPlugin, _cluster.mlPlugin, _cluster.corePlugin],
      ...globalConfig.opensearch
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_cluster.flowFrameworkPlugin);
      dataSource.registerCustomApiSchema(_cluster.mlPlugin);
      dataSource.registerCustomApiSchema(_cluster.corePlugin);
    }
    const opensearchRoutesService = new _routes.OpenSearchRoutesService(client, dataSourceEnabled);
    const flowFrameworkRoutesService = new _routes.FlowFrameworkRoutesService(client, dataSourceEnabled);
    const mlRoutesService = new _routes.MLRoutesService(client, dataSourceEnabled);

    // Register server side APIs with the corresponding service functions
    (0, _routes.registerOpenSearchRoutes)(router, opensearchRoutesService);
    (0, _routes.registerFlowFrameworkRoutes)(router, flowFrameworkRoutesService);
    (0, _routes.registerMLRoutes)(router, mlRoutesService);
    return {};
  }
  start(core) {
    this.logger.debug('flow-framework-dashboards: Started');
    return {};
  }
  stop() {}
}
exports.FlowFrameworkDashboardsPlugin = FlowFrameworkDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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