"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AliasServices extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [aliases, apiAccessible, errMsg] = await getAliases(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = AliasServices;
async function getAliases(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }
    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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