"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAssetsFromFile = exports.createIndexTemplate = exports.createAllTemplatesSettled = exports.assetMapper = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _getting_started_routes = require("../../../common/constants/getting_started_routes");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const assetMapper = tutorialId => {
  const component = _getting_started_routes.COMPONENT_MAP[tutorialId] || 'default-component';
  const version = _getting_started_routes.VERSION_MAP[tutorialId] || '1.0.0';
  const signal = _getting_started_routes.SIGNAL_MAP[tutorialId] ? `-${_getting_started_routes.SIGNAL_MAP[tutorialId]}` : '';
  return `${component}-${version}${signal}.ndjson`;
};
exports.assetMapper = assetMapper;
const loadAssetsFromFile = async tutorialId => {
  try {
    const fileName = assetMapper(tutorialId);
    const filePath = _path.default.join(__dirname, `assets/${fileName}`);
    const fileData = await _fs.default.promises.readFile(filePath, 'utf8');
    return fileData;
  } catch (error) {
    throw new Error(`Error loading asset: ${tutorialId}`);
  }
};
exports.loadAssetsFromFile = loadAssetsFromFile;
const createAllTemplatesSettled = async (context, indexTemplates, dataSourceMDSId) => {
  const results = await Promise.allSettled(indexTemplates.map(({
    name,
    template,
    templatePath
  }) => createIndexTemplate(context, name, template, dataSourceMDSId, templatePath)));
  return results.map((result, index) => {
    const templateName = indexTemplates[index].name;
    if (result.status === 'fulfilled') {
      return {
        name: templateName,
        success: true
      };
    }
    return {
      name: templateName,
      success: false,
      reason: result.reason
    };
  });
};
exports.createAllTemplatesSettled = createAllTemplatesSettled;
const createIndexTemplate = async (context, name, template, dataSourceMDSId, templatePath) => {
  try {
    const osClient = dataSourceMDSId ? await context.dataSource.opensearch.getClient(dataSourceMDSId) : context.core.opensearch.client.asCurrentUser;
    return await osClient.transport.request({
      method: 'PUT',
      path: templatePath,
      body: template
    });
  } catch (error) {
    console.error(`Failed to create index template ${name}:`, error);
    throw error;
  }
};
exports.createIndexTemplate = createIndexTemplate;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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