"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _datasources_router = require("./datasources/datasources_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _getting_started_router = require("./getting_started/getting_started_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client,
  dataSourceEnabled,
  logger
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  }, dataSourceEnabled);
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router, dataSourceEnabled);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router, dataSourceEnabled);
  const queryService = new _queryService.QueryService(client, logger);
  (0, _sqlRouter.registerSqlRoute)(router, queryService, dataSourceEnabled);
  (0, _metrics_rounter.registerMetricsRoute)(router, dataSourceEnabled);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router, dataSourceEnabled);
  (0, _datasources_router.registerDatasourcesRoute)(router, dataSourceEnabled);

  // query assist is part of log explorer, which will be disabled if datasource is enabled
  if (!dataSourceEnabled) {
    (0, _routes.registerQueryAssistRoutes)(router);
  }
  (0, _getting_started_router.registerGettingStartedRoutes)(router);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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