"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveQueryById = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Utility function to fetch query by id and time range
const retrieveQueryById = async (core, dataSourceId, start, end, id) => {
  const nullResponse = {
    response: {
      top_queries: []
    }
  };
  const params = {
    query: {
      dataSourceId,
      from: start,
      to: end,
      id
    }
  };
  const fetchMetric = async endpoint => {
    try {
      var _response$response;
      const response = await core.http.get(endpoint, params);
      return {
        response: {
          top_queries: Array.isArray(response === null || response === void 0 || (_response$response = response.response) === null || _response$response === void 0 ? void 0 : _response$response.top_queries) ? response.response.top_queries : []
        }
      };
    } catch (error) {
      console.error('Error occurred while fetching the data:', error);
      return nullResponse;
    }
  };
  try {
    const topQueriesResponse = await Promise.any([fetchMetric(`/api/top_queries/latency`), fetchMetric(`/api/top_queries/cpu`), fetchMetric(`/api/top_queries/memory`)]);
    return topQueriesResponse.response.top_queries[0] || null;
  } catch (error) {
    console.error('Error retrieving query details:', error);
    return null;
  }
};
exports.retrieveQueryById = retrieveQueryById;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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