/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math;

import java.io.Serializable;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.GroupElement;

public class Curve
implements Serializable {
    private static final long serialVersionUID = 4578920872509827L;
    private final Field f;
    private final FieldElement d;
    private final FieldElement d2;
    private final FieldElement I;
    private final GroupElement zeroP2;
    private final GroupElement zeroP3;
    private final GroupElement zeroPrecomp;

    public Curve(Field field, byte[] byArray, FieldElement fieldElement) {
        this.f = field;
        this.d = field.fromByteArray(byArray);
        this.d2 = this.d.add(this.d);
        this.I = fieldElement;
        FieldElement fieldElement2 = field.ZERO;
        FieldElement fieldElement3 = field.ONE;
        this.zeroP2 = GroupElement.p2(this, fieldElement2, fieldElement3, fieldElement3);
        this.zeroP3 = GroupElement.p3(this, fieldElement2, fieldElement3, fieldElement3, fieldElement2);
        this.zeroPrecomp = GroupElement.precomp(this, fieldElement3, fieldElement3, fieldElement2);
    }

    public Field getField() {
        return this.f;
    }

    public FieldElement getD() {
        return this.d;
    }

    public FieldElement get2D() {
        return this.d2;
    }

    public FieldElement getI() {
        return this.I;
    }

    public GroupElement getZero(GroupElement.Representation representation) {
        switch (representation) {
            case P2: {
                return this.zeroP2;
            }
            case P3: {
                return this.zeroP3;
            }
            case PRECOMP: {
                return this.zeroPrecomp;
            }
        }
        return null;
    }

    public GroupElement createPoint(byte[] byArray, boolean bl) {
        GroupElement groupElement = new GroupElement(this, byArray);
        if (bl) {
            groupElement.precompute(true);
        }
        return groupElement;
    }

    public int hashCode() {
        return this.f.hashCode() ^ this.d.hashCode() ^ this.I.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Curve)) {
            return false;
        }
        Curve curve = (Curve)object;
        return this.f.equals(curve.getField()) && this.d.equals(curve.getD()) && this.I.equals(curve.getI());
    }
}

