/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.readline.terminal.DeviceBuilder;
import org.aesh.readline.terminal.impl.SignalHandlers;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Device;
import org.aesh.terminal.Terminal;
import org.aesh.terminal.tty.Signal;

public abstract class AbstractTerminal
implements Terminal {
    protected final Logger LOGGER = LoggerUtil.getLogger(this.getClass().getName());
    protected final String name;
    protected final String type;
    protected final Map<Signal, Terminal.SignalHandler> handlers = new HashMap<Signal, Terminal.SignalHandler>();
    protected final Device device;

    public AbstractTerminal(String name, String type) throws IOException {
        this(name, type, SignalHandlers.SIG_DFL);
    }

    public AbstractTerminal(String name, String type, Terminal.SignalHandler signalHandler) throws IOException {
        this.name = name;
        this.type = type;
        for (Signal signal : Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
        this.device = DeviceBuilder.builder().name(type).build();
    }

    @Override
    public Terminal.SignalHandler handle(Signal signal, Terminal.SignalHandler handler) {
        assert (signal != null);
        assert (handler != null);
        return this.handlers.put(signal, handler);
    }

    @Override
    public void raise(Signal signal) {
        assert (signal != null);
        Terminal.SignalHandler handler = this.handlers.get((Object)signal);
        if (handler == SignalHandlers.SIG_DFL) {
            this.handleDefaultSignal(signal);
        } else if (handler != SignalHandlers.SIG_IGN) {
            handler.handle(signal);
        }
    }

    protected void handleDefaultSignal(Signal signal) {
    }

    protected void echoSignal(Signal signal) {
        int vcc;
        Attributes.ControlChar cc = null;
        switch (signal) {
            case INT: {
                cc = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                cc = Attributes.ControlChar.VQUIT;
                break;
            }
            case SUSP: {
                cc = Attributes.ControlChar.VSUSP;
            }
        }
        if (cc != null && (vcc = this.getAttributes().getControlChar(cc)) > 0 && vcc < 32) {
            try {
                this.output().write(new String(new char[]{'^', (char)(vcc + 64)}).getBytes());
            }
            catch (IOException e) {
                this.LOGGER.log(Level.WARNING, "Failed to write out ^(C) - or other signals", e);
            }
        }
    }

    @Override
    public boolean echo() {
        return this.getAttributes().getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    @Override
    public boolean echo(boolean echo) {
        Attributes attr = this.getAttributes();
        boolean prev = attr.getLocalFlag(Attributes.LocalFlag.ECHO);
        if (prev != echo) {
            attr.setLocalFlag(Attributes.LocalFlag.ECHO, echo);
            this.setAttributes(attr);
        }
        return prev;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Device device() {
        return this.device;
    }
}

