/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.stat.TimerTracker;

public class FunctionTimerTrackerImpl
implements TimerTracker {
    private final LongAdder counter = new LongAdder();
    private final DoubleAdder totalTime = new DoubleAdder();

    FunctionTimerTrackerImpl() {
    }

    public void update(Duration duration) {
        this.update(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void update(long value, TimeUnit timeUnit) {
        this.counter.increment();
        this.totalTime.add(TimeUtils.convert((double)value, (TimeUnit)timeUnit, (TimeUnit)TimeUnit.NANOSECONDS));
    }

    public long count() {
        return this.counter.sum();
    }

    private double totalTime() {
        return this.totalTime.sum();
    }

    public FunctionTimer.Builder<FunctionTimerTrackerImpl> create(String metricName) {
        return FunctionTimer.builder((String)metricName, (Object)this, FunctionTimerTrackerImpl::count, FunctionTimerTrackerImpl::totalTime, (TimeUnit)TimeUnit.NANOSECONDS);
    }
}

