/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.MonitorableImpl;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public abstract class ProgressAction
extends AbstractArchitectAction {
    public ProgressAction(ArchitectSwingSession session, PlayPen playpen, String actionName, String actionDescription, Icon icon) {
        super(session, playpen, actionName, actionDescription, icon);
    }

    public ProgressAction(ArchitectFrame frame, String actionName, String actionDescription, Icon icon) {
        super(frame, actionName, actionDescription, icon);
    }

    public ProgressAction(ArchitectSwingSession session, String actionName, String actionDescription, Icon icon) {
        super(session, actionName, actionDescription, icon);
    }

    public ProgressAction(ArchitectSwingSession session, String actionName, String actionDescription) {
        super(session, actionName, actionDescription);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        final JDialog progressDialog = new JDialog(this.frame, Messages.getString("ProgressAction.name"), false);
        progressDialog.setLocationRelativeTo(this.frame);
        progressDialog.setTitle(this.getDialogMessage());
        PanelBuilder pb = new PanelBuilder(new FormLayout("4dlu,fill:min(100dlu;default):grow, pref, fill:min(100dlu;default):grow,4dlu", "4dlu,pref,4dlu, pref, 6dlu, pref,4dlu"));
        JLabel label = new JLabel(this.getDialogMessage());
        JProgressBar progressBar = new JProgressBar();
        final MonitorableImpl monitor = new MonitorableImpl();
        if (!this.setup(monitor, properties)) {
            return;
        }
        CellConstraints c = new CellConstraints();
        pb.add((Component)label, c.xyw(2, 2, 3));
        pb.add((Component)progressBar, c.xyw(2, 4, 3));
        pb.add((Component)new JButton(new AbstractAction(this.getButtonText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                progressDialog.dispose();
                monitor.setCancelled(true);
            }
        }), c.xy(3, 6));
        progressDialog.add(pb.getPanel());
        SPSwingWorker worker = new SPSwingWorker(this.getSession()){

            public void cleanup() throws Exception {
                if (this.getDoStuffException() != null) {
                    ASUtils.showExceptionDialog(ProgressAction.this.getSession(), Messages.getString("ProgressAction.unexpectedException"), this.getDoStuffException());
                }
                ProgressAction.this.cleanUp(monitor);
                monitor.setFinished(true);
                progressDialog.dispose();
            }

            public void doStuff() throws Exception {
                ProgressAction.this.doStuff(monitor, properties);
            }
        };
        ProgressWatcher.watchProgress((JProgressBar)progressBar, (Monitorable)monitor);
        progressDialog.pack();
        progressDialog.setVisible(true);
        new Thread((Runnable)worker).start();
    }

    public abstract String getButtonText();

    public abstract boolean setup(MonitorableImpl var1, Map<String, Object> var2);

    public abstract void doStuff(MonitorableImpl var1, Map<String, Object> var2);

    public abstract void cleanUp(MonitorableImpl var1);

    public abstract String getDialogMessage();
}

