/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.softwareinfo.form.SoftwareInfoForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;

public final class SoftwareInfoManager
extends Manager {
    private static final Map<XMPPConnection, SoftwareInfoManager> INSTANCES = new WeakHashMap<XMPPConnection, SoftwareInfoManager>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized SoftwareInfoManager getInstanceFor(XMPPConnection connection) {
        SoftwareInfoManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new SoftwareInfoManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private SoftwareInfoManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
    }

    public void publishSoftwareInformationForm(SoftwareInfoForm softwareInfoForm) {
        this.serviceDiscoveryManager.addExtendedInfo(softwareInfoForm.getDataForm());
    }

    public SoftwareInfoForm fromJid(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo discoverInfo = this.serviceDiscoveryManager.discoverInfo(jid);
        DataForm dataForm = DataForm.from(discoverInfo, "urn:xmpp:dataforms:softwareinfo");
        if (dataForm == null) {
            return null;
        }
        return SoftwareInfoForm.getBuilder().setDataForm(dataForm).build();
    }
}

