/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVideoBindMemoryKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYBINDINDEX;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int MEMORYSIZE;

    public VkVideoBindMemoryKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoBindMemoryKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoBindMemoryKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoBindMemoryKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryBindIndex() {
        return VkVideoBindMemoryKHR.nmemoryBindIndex(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkVideoBindMemoryKHR.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkVideoBindMemoryKHR.nmemoryOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memorySize() {
        return VkVideoBindMemoryKHR.nmemorySize(this.address());
    }

    public VkVideoBindMemoryKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoBindMemoryKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR sType$Default() {
        return this.sType(1000023004);
    }

    public VkVideoBindMemoryKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoBindMemoryKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR memoryBindIndex(@NativeType(value="uint32_t") int value) {
        VkVideoBindMemoryKHR.nmemoryBindIndex(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkVideoBindMemoryKHR.nmemory(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoBindMemoryKHR.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR memorySize(@NativeType(value="VkDeviceSize") long value) {
        VkVideoBindMemoryKHR.nmemorySize(this.address(), value);
        return this;
    }

    public VkVideoBindMemoryKHR set(int sType, long pNext, int memoryBindIndex, long memory, long memoryOffset, long memorySize) {
        this.sType(sType);
        this.pNext(pNext);
        this.memoryBindIndex(memoryBindIndex);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.memorySize(memorySize);
        return this;
    }

    public VkVideoBindMemoryKHR set(VkVideoBindMemoryKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoBindMemoryKHR malloc() {
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkVideoBindMemoryKHR calloc() {
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkVideoBindMemoryKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkVideoBindMemoryKHR create(long address) {
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)address);
    }

    @Nullable
    public static VkVideoBindMemoryKHR createSafe(long address) {
        return address == 0L ? null : (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkVideoBindMemoryKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoBindMemoryKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkVideoBindMemoryKHR malloc(MemoryStack stack) {
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoBindMemoryKHR calloc(MemoryStack stack) {
        return (VkVideoBindMemoryKHR)VkVideoBindMemoryKHR.wrap(VkVideoBindMemoryKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVideoBindMemoryKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nmemoryBindIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYBINDINDEX);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYOFFSET);
    }

    public static long nmemorySize(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYSIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemoryBindIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYBINDINDEX, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYOFFSET, value);
    }

    public static void nmemorySize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYSIZE, value);
    }

    static {
        Struct.Layout layout = VkVideoBindMemoryKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoBindMemoryKHR.__member((int)4), VkVideoBindMemoryKHR.__member((int)POINTER_SIZE), VkVideoBindMemoryKHR.__member((int)4), VkVideoBindMemoryKHR.__member((int)8), VkVideoBindMemoryKHR.__member((int)8), VkVideoBindMemoryKHR.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYBINDINDEX = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
        MEMORYOFFSET = layout.offsetof(4);
        MEMORYSIZE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkVideoBindMemoryKHR, Buffer>
    implements NativeResource {
        private static final VkVideoBindMemoryKHR ELEMENT_FACTORY = VkVideoBindMemoryKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkVideoBindMemoryKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoBindMemoryKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoBindMemoryKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryBindIndex() {
            return VkVideoBindMemoryKHR.nmemoryBindIndex(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkVideoBindMemoryKHR.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkVideoBindMemoryKHR.nmemoryOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memorySize() {
            return VkVideoBindMemoryKHR.nmemorySize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoBindMemoryKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoBindMemoryKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer memoryBindIndex(@NativeType(value="uint32_t") int value) {
            VkVideoBindMemoryKHR.nmemoryBindIndex(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkVideoBindMemoryKHR.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoBindMemoryKHR.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer memorySize(@NativeType(value="VkDeviceSize") long value) {
            VkVideoBindMemoryKHR.nmemorySize(this.address(), value);
            return this;
        }
    }
}

