/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import tr.model.action.Action;
import tr.model.action.ActionSelector;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.topic.Topic;
import tr.util.DateUtils;

public class ActionSelectorImpl
implements ActionSelector {
    public static final Class ACTION_STATE_ASAP = ActionStateASAP.class;
    public static final Class ACTION_STATE_SCHEDULED = ActionStateScheduled.class;
    public static final Class ACTION_STATE_DELEGATED = ActionStateDelegated.class;
    public static final Class ACTION_STATE_INACTIVE = ActionStateInactive.class;
    public static final Class[] ACTION_STATES = new Class[]{ACTION_STATE_ASAP, ACTION_STATE_SCHEDULED, ACTION_STATE_DELEGATED, ACTION_STATE_INACTIVE};
    private String name;
    private final Vector<Class> actionStates;
    private final Vector<Context> contexts;
    private final Vector<Topic> topics;
    private final Vector<Boolean> doneValues;
    private final Vector<Boolean> activeValues;
    private boolean checkFutureDays = false;
    private int futureDays;
    private Date createdFrom = null;
    private Date createdTo = null;
    private Date doneFrom = null;
    private Date doneTo = null;

    public ActionSelectorImpl() {
        this("");
    }

    public ActionSelectorImpl(String name) {
        this.name = name;
        this.actionStates = new Vector();
        this.contexts = new Vector();
        this.topics = new Vector();
        this.doneValues = new Vector();
        this.activeValues = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
    }

    public void clearAll() {
        this.actionStates.clear();
        this.contexts.clear();
        this.topics.clear();
        this.doneValues.clear();
        this.activeValues.clear();
        this.createdFrom = null;
        this.createdTo = null;
        this.doneFrom = null;
        this.doneTo = null;
    }

    public void addActionState(Class actionState) {
        this.actionStates.add(actionState);
    }

    public void addActionContext(Context context) {
        this.contexts.add(context);
    }

    public void addActionTopic(Topic topic) {
        this.topics.add(topic);
    }

    public void addDoneValue(boolean done) {
        this.doneValues.add(new Boolean(done));
    }

    public void clearDoneValues() {
        this.doneValues.removeAllElements();
    }

    public void addActiveValue(boolean active) {
        this.activeValues.add(new Boolean(active));
    }

    public void setCheckFutureDays(boolean b) {
        this.checkFutureDays = b;
    }

    public void setFutureDays(int days) {
        this.futureDays = days;
    }

    public void setCreatedFrom(Date date) {
        this.createdFrom = date;
    }

    public void setCreatedTo(Date date) {
        this.createdTo = date;
    }

    public void setDoneFrom(Date date) {
        this.doneFrom = date;
    }

    public void setDoneTo(Date date) {
        this.doneTo = date;
    }

    public boolean isSelected(Action action) {
        if (this.doneValues.size() > 0) {
            boolean found = false;
            for (Boolean b : this.doneValues) {
                if (action.isDone() != b.booleanValue()) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        Date created = action.getCreated();
        if (this.createdFrom != null && !created.after(this.createdFrom)) {
            return false;
        }
        if (this.createdTo != null && !created.before(this.createdTo)) {
            return false;
        }
        Date done = action.getDoneDate();
        if (!(this.doneFrom == null || done != null && done.after(this.doneFrom))) {
            return false;
        }
        if (!(this.doneTo == null || done != null && done.before(this.doneTo))) {
            return false;
        }
        if (this.activeValues.size() > 0) {
            boolean found = false;
            for (Boolean b : this.activeValues) {
                if (action.isActive() != b.booleanValue()) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.actionStates.size() == 0) {
            return false;
        }
        boolean found = false;
        for (Class c : this.actionStates) {
            if (!c.isInstance((Object)action.getState())) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (this.contexts.size() > 0) {
            found = false;
            for (Context context : this.contexts) {
                if (!action.getContext().equals(context)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.topics.size() > 0) {
            found = false;
            for (Topic topic : this.topics) {
                if (!action.getTopic().equals(topic)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.checkFutureDays) {
            Date date;
            Calendar future = Calendar.getInstance();
            future.add(6, this.futureDays + 1);
            if (action.getState() instanceof ActionStateDelegated) {
                date = ((ActionStateDelegated)action.getState()).getDate();
                if (date == null) {
                    return true;
                }
                if (!DateUtils.isBeforeDay((Date)date, (Date)future.getTime())) {
                    return false;
                }
            } else if (action.getState() instanceof ActionStateScheduled) {
                date = ((ActionStateScheduled)action.getState()).getDate();
                if (date == null) {
                    return true;
                }
                if (!DateUtils.isBeforeDay((Date)date, (Date)future.getTime())) {
                    return false;
                }
            }
        }
        return true;
    }
}

