/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.EntityBareJid;

public class LoginUrlIq
extends IQ {
    public static final String NAMESPACE = "http://jitsi.org/protocol/focus";
    public static final String ELEMENT = "login-url";
    public static final String URL_ATTRIBUTE_NAME = "url";
    public static final String ROOM_NAME_ATTR_NAME = "room";
    public static final String POPUP_ATTR_NAME = "popup";
    public static final String MACHINE_UID_ATTR_NAME = "machine-uid";
    private String url;
    private EntityBareJid room;
    private String machineUID;
    private Boolean popup;

    public LoginUrlIq() {
        super(ELEMENT, NAMESPACE);
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        if (StringUtils.isNotEmpty(this.url)) {
            try {
                String value2 = URLEncoder.encode(this.url, "UTF-8");
                xml.attribute(URL_ATTRIBUTE_NAME, value2);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        xml.optAttribute(ROOM_NAME_ATTR_NAME, this.room);
        xml.optAttribute(MACHINE_UID_ATTR_NAME, this.machineUID);
        if (this.popup != null) {
            xml.attribute(POPUP_ATTR_NAME, this.popup);
        }
        xml.setEmptyElement();
        return xml;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        try {
            this.url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityBareJid getRoom() {
        return this.room;
    }

    public void setRoom(EntityBareJid room) {
        this.room = room;
    }

    public Boolean getPopup() {
        return this.popup;
    }

    public void setPopup(Boolean popup) {
        this.popup = popup;
    }

    public String getMachineUID() {
        return this.machineUID;
    }

    public void setMachineUID(String machineUID) {
        this.machineUID = machineUID;
    }
}

