/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.virtual.threads;

import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class FallbackVirtualThreadsExecutorService
extends AbstractExecutorService {
    private AtomicBoolean shutdown = new AtomicBoolean();

    FallbackVirtualThreadsExecutorService() {
    }

    @Override
    public void execute(Runnable command) {
        Context context = Vertx.currentContext();
        if (!(context instanceof ContextInternal)) {
            Infrastructure.getDefaultWorkerPool().execute(command);
        } else {
            context.executeBlocking(() -> {
                command.run();
                return null;
            }, false);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown.compareAndSet(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown.compareAndSet(false, true);
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        this.shutdown.compareAndSet(false, true);
        return true;
    }
}

