/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;

public abstract class TableFObj
extends FObj {
    private Numeric borderAfterPrecedence;
    private Numeric borderBeforePrecedence;
    private Numeric borderEndPrecedence;
    private Numeric borderStartPrecedence;

    public TableFObj(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.borderAfterPrecedence = pList.get(20).getNumeric();
        this.borderBeforePrecedence = pList.get(24).getNumeric();
        this.borderEndPrecedence = pList.get(34).getNumeric();
        this.borderStartPrecedence = pList.get(48).getNumeric();
        if (this.getNameId() != 46 && this.getNameId() != 50 && this.getTable().isSeparateBorderModel() && this.getCommonBorderPaddingBackground().hasBorderInfo()) {
            this.attributeWarning("In the separate border model (border-collapse=\"separate\"), borders are not applicable to " + this.getName() + ", but a non-zero value for border was found.");
        }
        if (this.getNameId() != 46 && this.getNameId() != 50 && this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContextForValidationPurposes())) {
            this.attributeWarning("padding-* properties are not applicable to " + this.getName() + ", but a non-zero value for padding was found.");
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (!this.inMarker() && child.getNameId() == 50) {
            this.updateColumnIndex((TableCell)child);
        }
        super.addChildNode(child);
    }

    private void updateColumnIndex(TableCell cell) throws ValidationException {
        int rowSpan = cell.getNumberRowsSpanned();
        int colSpan = cell.getNumberColumnsSpanned();
        int columnIndex = this.getCurrentColumnIndex();
        int i = -1;
        while (++i < colSpan) {
            if (!this.isColumnNumberUsed(columnIndex + i)) continue;
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("fo:table-cell overlaps in column ").append(columnIndex + i);
            if (this.locator.getLineNumber() != -1) {
                errorMessage.append(" (line #").append(this.locator.getLineNumber()).append(", column #").append(this.locator.getColumnNumber()).append(")");
            }
            throw new ValidationException(errorMessage.toString());
        }
        if (this.getNameId() == 54) {
            TableRow row = (TableRow)this;
            i = colSpan;
            while (--i >= 0) {
                row.pendingSpans.add(null);
            }
            if (rowSpan > 1) {
                i = colSpan;
                while (--i >= 0) {
                    row.pendingSpans.set(columnIndex - 1 + i, new PendingSpan(rowSpan));
                }
            }
        } else {
            TableBody body = (TableBody)this;
            if (body.firstRow && cell.startsRow() && !body.previousCellEndedRow()) {
                body.firstRow = false;
            }
            if (body.firstRow) {
                i = colSpan;
                while (--i >= 0) {
                    body.pendingSpans.add(null);
                }
            }
            if (rowSpan > 1) {
                i = colSpan;
                while (--i >= 0) {
                    body.pendingSpans.set(columnIndex - 1 + i, new PendingSpan(rowSpan));
                }
            }
        }
        int startIndex = columnIndex - 1;
        int endIndex = startIndex + colSpan;
        if (this.getTable().columns != null) {
            List cols = this.getTable().columns;
            int tmpIndex = endIndex;
            for (i = startIndex; i <= tmpIndex; ++i) {
                if (i >= cols.size() || cols.get(i) != null) continue;
                ++endIndex;
            }
        }
        this.flagColumnIndices(startIndex, endIndex);
        if (this.getNameId() != 54 && cell.endsRow()) {
            ((TableBody)this).firstRow = false;
            ((TableBody)this).resetColumnIndex();
        }
    }

    public Numeric getBorderPrecedence(int side) {
        switch (side) {
            case 0: {
                return this.borderBeforePrecedence;
            }
            case 1: {
                return this.borderAfterPrecedence;
            }
            case 2: {
                return this.borderStartPrecedence;
            }
            case 3: {
                return this.borderEndPrecedence;
            }
        }
        return null;
    }

    protected int getCurrentColumnIndex() {
        return 0;
    }

    protected void setCurrentColumnIndex(int newIndex) {
    }

    public boolean isColumnNumberUsed(int colNr) {
        return false;
    }

    public Table getTable() {
        if (this.getNameId() == 46) {
            return (Table)this;
        }
        return ((TableFObj)this.parent).getTable();
    }

    public abstract CommonBorderPaddingBackground getCommonBorderPaddingBackground();

    protected void flagColumnIndices(int start, int end) {
    }

    public static class ColumnNumberPropertyMaker
    extends NumberProperty.Maker {
        public ColumnNumberPropertyMaker(int propId) {
            super(propId);
        }

        public Property make(PropertyList propertyList) throws PropertyException {
            FObj fo = propertyList.getFObj();
            if (fo.getNameId() == 50 || fo.getNameId() == 51) {
                TableBody parent;
                if (fo.getNameId() == 50 && fo.getParent().getNameId() != 54 && propertyList.get(213).getEnum() == 149 && !(parent = (TableBody)fo.getParent()).previousCellEndedRow()) {
                    parent.resetColumnIndex();
                }
                return new NumberProperty(((TableFObj)fo.getParent()).getCurrentColumnIndex());
            }
            throw new PropertyException("column-number property is only allowed on fo:table-cell or fo:table-column, not on " + fo.getName());
        }

        public Property get(int subpropId, PropertyList propertyList, boolean tryInherit, boolean tryDefault) throws PropertyException {
            Property p = super.get(0, propertyList, tryInherit, tryDefault);
            TableFObj fo = (TableFObj)propertyList.getFObj();
            TableFObj parent = (TableFObj)propertyList.getParentFObj();
            if (p != null) {
                int columnIndex = p.getNumeric().getValue();
                if (columnIndex <= 0) {
                    fo.getLogger().warn((Object)("Specified negative or zero value for column-number on " + fo.getName() + ": " + columnIndex + " forced to " + parent.getCurrentColumnIndex()));
                    return new NumberProperty(parent.getCurrentColumnIndex());
                }
                double tmpIndex = p.getNumeric().getNumericValue();
                if (tmpIndex - (double)columnIndex > 0.0) {
                    columnIndex = (int)Math.round(tmpIndex);
                    fo.getLogger().warn((Object)("Rounding specified column-number of " + tmpIndex + " to " + columnIndex));
                    return new NumberProperty(columnIndex);
                }
                if (propertyList.getExplicit(70) != null) {
                    parent.setCurrentColumnIndex(p.getNumeric().getValue());
                }
            }
            return p;
        }
    }

    protected static class PendingSpan {
        protected int rowsLeft;

        public PendingSpan(int rows) {
            this.rowsLeft = rows;
        }
    }
}

